/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.opensearch;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.opensearch.OpensearchClusterAsyncClient;
import com.oracle.bmc.opensearch.requests.BackupOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.CreateOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.DeleteOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetWorkRequestRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchClustersRequest;
import com.oracle.bmc.opensearch.requests.ListOpensearchVersionsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.opensearch.requests.ListWorkRequestsRequest;
import com.oracle.bmc.opensearch.requests.OpensearchClusterRestoreRequest;
import com.oracle.bmc.opensearch.requests.ResizeOpensearchClusterHorizontalRequest;
import com.oracle.bmc.opensearch.requests.ResizeOpensearchClusterVerticalRequest;
import com.oracle.bmc.opensearch.requests.UpdateOpensearchClusterRequest;
import com.oracle.bmc.opensearch.responses.BackupOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.CreateOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.DeleteOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetWorkRequestResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchClustersResponse;
import com.oracle.bmc.opensearch.responses.ListOpensearchVersionsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.opensearch.responses.ListWorkRequestsResponse;
import com.oracle.bmc.opensearch.responses.OpensearchClusterRestoreResponse;
import com.oracle.bmc.opensearch.responses.ResizeOpensearchClusterHorizontalResponse;
import com.oracle.bmc.opensearch.responses.ResizeOpensearchClusterVerticalResponse;
import com.oracle.bmc.opensearch.responses.UpdateOpensearchClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OpensearchClusterAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OpensearchClusterRxClient {
    OpensearchClusterAsyncClient client;

    OpensearchClusterRxClient(OpensearchClusterAsyncClient client) {
        this.client = client;
    }

    public Single<BackupOpensearchClusterResponse> backupOpensearchCluster(BackupOpensearchClusterRequest request) {
        return Single.create(emitter -> this.client.backupOpensearchCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateOpensearchClusterResponse> createOpensearchCluster(CreateOpensearchClusterRequest request) {
        return Single.create(emitter -> this.client.createOpensearchCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteOpensearchClusterResponse> deleteOpensearchCluster(DeleteOpensearchClusterRequest request) {
        return Single.create(emitter -> this.client.deleteOpensearchCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOpensearchClusterResponse> getOpensearchCluster(GetOpensearchClusterRequest request) {
        return Single.create(emitter -> this.client.getOpensearchCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOpensearchClustersResponse> listOpensearchClusters(ListOpensearchClustersRequest request) {
        return Single.create(emitter -> this.client.listOpensearchClusters(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOpensearchVersionsResponse> listOpensearchVersions(ListOpensearchVersionsRequest request) {
        return Single.create(emitter -> this.client.listOpensearchVersions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<OpensearchClusterRestoreResponse> opensearchClusterRestore(OpensearchClusterRestoreRequest request) {
        return Single.create(emitter -> this.client.opensearchClusterRestore(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ResizeOpensearchClusterHorizontalResponse> resizeOpensearchClusterHorizontal(ResizeOpensearchClusterHorizontalRequest request) {
        return Single.create(emitter -> this.client.resizeOpensearchClusterHorizontal(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ResizeOpensearchClusterVerticalResponse> resizeOpensearchClusterVertical(ResizeOpensearchClusterVerticalRequest request) {
        return Single.create(emitter -> this.client.resizeOpensearchClusterVertical(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateOpensearchClusterResponse> updateOpensearchCluster(UpdateOpensearchClusterRequest request) {
        return Single.create(emitter -> this.client.updateOpensearchCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

