/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.osmanagementhub;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osmanagementhub.ReportingManagedInstanceAsyncClient;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceAnalyticContentRequest;
import com.oracle.bmc.osmanagementhub.requests.GetManagedInstanceContentRequest;
import com.oracle.bmc.osmanagementhub.requests.SummarizeManagedInstanceAnalyticsRequest;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceAnalyticContentResponse;
import com.oracle.bmc.osmanagementhub.responses.GetManagedInstanceContentResponse;
import com.oracle.bmc.osmanagementhub.responses.SummarizeManagedInstanceAnalyticsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ReportingManagedInstanceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ReportingManagedInstanceRxClient {
    ReportingManagedInstanceAsyncClient client;

    ReportingManagedInstanceRxClient(ReportingManagedInstanceAsyncClient client) {
        this.client = client;
    }

    public Single<GetManagedInstanceAnalyticContentResponse> getManagedInstanceAnalyticContent(GetManagedInstanceAnalyticContentRequest request) {
        return Single.create(emitter -> this.client.getManagedInstanceAnalyticContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetManagedInstanceContentResponse> getManagedInstanceContent(GetManagedInstanceContentRequest request) {
        return Single.create(emitter -> this.client.getManagedInstanceContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeManagedInstanceAnalyticsResponse> summarizeManagedInstanceAnalytics(SummarizeManagedInstanceAnalyticsRequest request) {
        return Single.create(emitter -> this.client.summarizeManagedInstanceAnalytics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

