/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.osubusage;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osubusage.ComputedUsageAsyncClient;
import com.oracle.bmc.osubusage.requests.GetComputedUsageRequest;
import com.oracle.bmc.osubusage.requests.ListComputedUsageAggregatedsRequest;
import com.oracle.bmc.osubusage.requests.ListComputedUsagesRequest;
import com.oracle.bmc.osubusage.responses.GetComputedUsageResponse;
import com.oracle.bmc.osubusage.responses.ListComputedUsageAggregatedsResponse;
import com.oracle.bmc.osubusage.responses.ListComputedUsagesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ComputedUsageAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ComputedUsageRxClient {
    ComputedUsageAsyncClient client;

    ComputedUsageRxClient(ComputedUsageAsyncClient client) {
        this.client = client;
    }

    public Single<GetComputedUsageResponse> getComputedUsage(GetComputedUsageRequest request) {
        return Single.create(emitter -> this.client.getComputedUsage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListComputedUsageAggregatedsResponse> listComputedUsageAggregateds(ListComputedUsageAggregatedsRequest request) {
        return Single.create(emitter -> this.client.listComputedUsageAggregateds(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListComputedUsagesResponse> listComputedUsages(ListComputedUsagesRequest request) {
        return Single.create(emitter -> this.client.listComputedUsages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

