/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.queue;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.queue.QueueAdminAsyncClient;
import com.oracle.bmc.queue.requests.ChangeQueueCompartmentRequest;
import com.oracle.bmc.queue.requests.CreateQueueRequest;
import com.oracle.bmc.queue.requests.DeleteQueueRequest;
import com.oracle.bmc.queue.requests.GetQueueRequest;
import com.oracle.bmc.queue.requests.GetWorkRequestRequest;
import com.oracle.bmc.queue.requests.ListQueuesRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.queue.requests.ListWorkRequestsRequest;
import com.oracle.bmc.queue.requests.PurgeQueueRequest;
import com.oracle.bmc.queue.requests.UpdateQueueRequest;
import com.oracle.bmc.queue.responses.ChangeQueueCompartmentResponse;
import com.oracle.bmc.queue.responses.CreateQueueResponse;
import com.oracle.bmc.queue.responses.DeleteQueueResponse;
import com.oracle.bmc.queue.responses.GetQueueResponse;
import com.oracle.bmc.queue.responses.GetWorkRequestResponse;
import com.oracle.bmc.queue.responses.ListQueuesResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.queue.responses.ListWorkRequestsResponse;
import com.oracle.bmc.queue.responses.PurgeQueueResponse;
import com.oracle.bmc.queue.responses.UpdateQueueResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={QueueAdminAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class QueueAdminRxClient {
    QueueAdminAsyncClient client;

    QueueAdminRxClient(QueueAdminAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeQueueCompartmentResponse> changeQueueCompartment(ChangeQueueCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeQueueCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateQueueResponse> createQueue(CreateQueueRequest request) {
        return Single.create(emitter -> this.client.createQueue(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteQueueResponse> deleteQueue(DeleteQueueRequest request) {
        return Single.create(emitter -> this.client.deleteQueue(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetQueueResponse> getQueue(GetQueueRequest request) {
        return Single.create(emitter -> this.client.getQueue(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListQueuesResponse> listQueues(ListQueuesRequest request) {
        return Single.create(emitter -> this.client.listQueues(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PurgeQueueResponse> purgeQueue(PurgeQueueRequest request) {
        return Single.create(emitter -> this.client.purgeQueue(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateQueueResponse> updateQueue(UpdateQueueRequest request) {
        return Single.create(emitter -> this.client.updateQueue(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

