/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.redis;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.redis.RedisClusterAsyncClient;
import com.oracle.bmc.redis.requests.CancelWorkRequestRequest;
import com.oracle.bmc.redis.requests.ChangeRedisClusterCompartmentRequest;
import com.oracle.bmc.redis.requests.CreateRedisClusterRequest;
import com.oracle.bmc.redis.requests.DeleteRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetRedisClusterRequest;
import com.oracle.bmc.redis.requests.GetWorkRequestRequest;
import com.oracle.bmc.redis.requests.ListRedisClustersRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.redis.requests.ListWorkRequestsRequest;
import com.oracle.bmc.redis.requests.UpdateRedisClusterRequest;
import com.oracle.bmc.redis.responses.CancelWorkRequestResponse;
import com.oracle.bmc.redis.responses.ChangeRedisClusterCompartmentResponse;
import com.oracle.bmc.redis.responses.CreateRedisClusterResponse;
import com.oracle.bmc.redis.responses.DeleteRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetRedisClusterResponse;
import com.oracle.bmc.redis.responses.GetWorkRequestResponse;
import com.oracle.bmc.redis.responses.ListRedisClustersResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.redis.responses.ListWorkRequestsResponse;
import com.oracle.bmc.redis.responses.UpdateRedisClusterResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={RedisClusterAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class RedisClusterRxClient {
    RedisClusterAsyncClient client;

    RedisClusterRxClient(RedisClusterAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeRedisClusterCompartmentResponse> changeRedisClusterCompartment(ChangeRedisClusterCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeRedisClusterCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateRedisClusterResponse> createRedisCluster(CreateRedisClusterRequest request) {
        return Single.create(emitter -> this.client.createRedisCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteRedisClusterResponse> deleteRedisCluster(DeleteRedisClusterRequest request) {
        return Single.create(emitter -> this.client.deleteRedisCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRedisClusterResponse> getRedisCluster(GetRedisClusterRequest request) {
        return Single.create(emitter -> this.client.getRedisCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRedisClustersResponse> listRedisClusters(ListRedisClustersRequest request) {
        return Single.create(emitter -> this.client.listRedisClusters(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateRedisClusterResponse> updateRedisCluster(UpdateRedisClusterRequest request) {
        return Single.create(emitter -> this.client.updateRedisCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

