/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.rover;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.WorkRequestsAsyncClient;
import com.oracle.bmc.rover.requests.CancelWorkRequestRequest;
import com.oracle.bmc.rover.requests.GetWorkRequestRequest;
import com.oracle.bmc.rover.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.rover.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.rover.requests.ListWorkRequestsRequest;
import com.oracle.bmc.rover.responses.CancelWorkRequestResponse;
import com.oracle.bmc.rover.responses.GetWorkRequestResponse;
import com.oracle.bmc.rover.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.rover.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.rover.responses.ListWorkRequestsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={WorkRequestsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WorkRequestsRxClient {
    WorkRequestsAsyncClient client;

    WorkRequestsRxClient(WorkRequestsAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

