/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.usage;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.usage.RewardsAsyncClient;
import com.oracle.bmc.usage.requests.CreateRedeemableUserRequest;
import com.oracle.bmc.usage.requests.DeleteRedeemableUserRequest;
import com.oracle.bmc.usage.requests.ListProductsRequest;
import com.oracle.bmc.usage.requests.ListRedeemableUsersRequest;
import com.oracle.bmc.usage.requests.ListRedemptionsRequest;
import com.oracle.bmc.usage.requests.ListRewardsRequest;
import com.oracle.bmc.usage.responses.CreateRedeemableUserResponse;
import com.oracle.bmc.usage.responses.DeleteRedeemableUserResponse;
import com.oracle.bmc.usage.responses.ListProductsResponse;
import com.oracle.bmc.usage.responses.ListRedeemableUsersResponse;
import com.oracle.bmc.usage.responses.ListRedemptionsResponse;
import com.oracle.bmc.usage.responses.ListRewardsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={RewardsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class RewardsRxClient {
    RewardsAsyncClient client;

    RewardsRxClient(RewardsAsyncClient client) {
        this.client = client;
    }

    public Single<CreateRedeemableUserResponse> createRedeemableUser(CreateRedeemableUserRequest request) {
        return Single.create(emitter -> this.client.createRedeemableUser(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteRedeemableUserResponse> deleteRedeemableUser(DeleteRedeemableUserRequest request) {
        return Single.create(emitter -> this.client.deleteRedeemableUser(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListProductsResponse> listProducts(ListProductsRequest request) {
        return Single.create(emitter -> this.client.listProducts(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRedeemableUsersResponse> listRedeemableUsers(ListRedeemableUsersRequest request) {
        return Single.create(emitter -> this.client.listRedeemableUsers(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRedemptionsResponse> listRedemptions(ListRedemptionsRequest request) {
        return Single.create(emitter -> this.client.listRedemptions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRewardsResponse> listRewards(ListRewardsRequest request) {
        return Single.create(emitter -> this.client.listRewards(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

