/*
 * Copyright 2017-2020 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.rabbitmq.serdes;

import io.micronaut.core.type.Argument;

import java.util.Optional;

/**
 * A registry of {@link RabbitMessageSerDes} instances. Responsible
 * for returning the serdes that supports the given type.
 *
 * @see RabbitMessageSerDes#supports(Argument)
 * @author James Kleeh
 * @since 1.1.0
 */
public interface RabbitMessageSerDesRegistry {

    /**
     * Returns the serdes that supports the given type.
     *
     * @param type The type
     * @param <T> The type to be serialized/deserialized
     * @return An optional serdes
     */
    <T> Optional<RabbitMessageSerDes<T>> findSerdes(Argument<T> type);
}
