/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import com.rabbitmq.client.Channel;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.messaging.exceptions.MessageAcknowledgementException;
import io.micronaut.rabbitmq.bind.AcknowledgmentAction;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import java.io.IOException;

public class RabbitMessageCloseable
implements AutoCloseable {
    private final Channel channel;
    private final long deliveryTag;
    private final boolean multiple;
    private final boolean reQueue;
    private AcknowledgmentAction acknowledgmentAction = AcknowledgmentAction.NONE;

    public RabbitMessageCloseable(RabbitConsumerState consumerState, boolean multiple, boolean reQueue) {
        this.channel = consumerState.getChannel();
        this.deliveryTag = consumerState.getEnvelope().getDeliveryTag();
        this.multiple = multiple;
        this.reQueue = reQueue;
    }

    @Override
    public void close() throws MessageAcknowledgementException {
        switch (this.acknowledgmentAction) {
            default: {
                break;
            }
            case ACK: {
                try {
                    this.channel.basicAck(this.deliveryTag, this.multiple);
                    break;
                }
                catch (IOException e) {
                    throw new MessageAcknowledgementException("An error occurred acknowledging a message", (Throwable)e);
                }
            }
            case NACK: {
                try {
                    this.channel.basicNack(this.deliveryTag, this.multiple, this.reQueue);
                    break;
                }
                catch (IOException e) {
                    throw new MessageAcknowledgementException("An error occurred rejecting a message", (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    public RabbitMessageCloseable withAcknowledge(@Nullable Boolean acknowledge) {
        this.acknowledgmentAction = acknowledge == null ? AcknowledgmentAction.NONE : (Boolean.TRUE.equals(acknowledge) ? AcknowledgmentAction.ACK : AcknowledgmentAction.NACK);
        return this;
    }

    public RabbitMessageCloseable withAcknowledgmentAction(@NonNull AcknowledgmentAction acknowledgmentAction) {
        this.acknowledgmentAction = acknowledgmentAction;
        return this;
    }
}

