/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import com.rabbitmq.client.AMQP;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.rabbitmq.annotation.RabbitProperty;
import io.micronaut.rabbitmq.bind.RabbitAnnotatedArgumentBinder;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@Singleton
public class RabbitPropertyBinder
implements RabbitAnnotatedArgumentBinder<RabbitProperty> {
    private final Map<String, Function<AMQP.BasicProperties, Object>> properties = new HashMap<String, Function<AMQP.BasicProperties, Object>>();
    private final ConversionService conversionService;

    public RabbitPropertyBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
        this.properties.put("contentType", AMQP.BasicProperties::getContentType);
        this.properties.put("contentEncoding", AMQP.BasicProperties::getContentEncoding);
        this.properties.put("deliveryMode", AMQP.BasicProperties::getDeliveryMode);
        this.properties.put("priority", AMQP.BasicProperties::getPriority);
        this.properties.put("correlationId", AMQP.BasicProperties::getCorrelationId);
        this.properties.put("replyTo", AMQP.BasicProperties::getReplyTo);
        this.properties.put("expiration", AMQP.BasicProperties::getExpiration);
        this.properties.put("messageId", AMQP.BasicProperties::getMessageId);
        this.properties.put("timestamp", AMQP.BasicProperties::getTimestamp);
        this.properties.put("type", AMQP.BasicProperties::getType);
        this.properties.put("userId", AMQP.BasicProperties::getUserId);
        this.properties.put("appId", AMQP.BasicProperties::getAppId);
        this.properties.put("clusterId", AMQP.BasicProperties::getClusterId);
    }

    public Class<RabbitProperty> getAnnotationType() {
        return RabbitProperty.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, RabbitConsumerState messageState) {
        Optional property = Optional.ofNullable(this.properties.get(this.getParameterName(context))).map(f -> f.apply(messageState.getProperties())).flatMap(prop -> this.conversionService.convert(prop, context));
        return () -> property;
    }

    public boolean supports(ArgumentConversionContext<Object> context) {
        return this.properties.containsKey(this.getParameterName(context));
    }

    private String getParameterName(ArgumentConversionContext<Object> context) {
        return context.getAnnotationMetadata().stringValue(RabbitProperty.class).orElse(context.getArgument().getName());
    }
}

