/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.exception;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.messaging.exceptions.MessageListenerException;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import java.util.Optional;

public class RabbitListenerException
extends MessageListenerException {
    private final Object listener;
    private final RabbitConsumerState messageState;

    public RabbitListenerException(String message, Object listener, @Nullable RabbitConsumerState messageState) {
        super(message);
        this.listener = listener;
        this.messageState = messageState;
    }

    public RabbitListenerException(String message, Throwable cause, Object listener, @Nullable RabbitConsumerState messageState) {
        super(message, cause);
        this.listener = listener;
        this.messageState = messageState;
    }

    public RabbitListenerException(Throwable cause, Object listener, @Nullable RabbitConsumerState messageState) {
        super(cause.getMessage(), cause);
        this.listener = listener;
        this.messageState = messageState;
    }

    public Object getListener() {
        return this.listener;
    }

    public Optional<RabbitConsumerState> getMessageState() {
        return Optional.ofNullable(this.messageState);
    }
}

