/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.intercept.MutableBasicProperties;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDes;
import jakarta.inject.Singleton;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

@Singleton
public class JavaLangRabbitMessageSerDes
implements RabbitMessageSerDes<Object> {
    public static final Integer ORDER = 100;
    protected final List<RabbitMessageSerDes> javaSerDes = new ArrayList<RabbitMessageSerDes>(10);

    public JavaLangRabbitMessageSerDes() {
        this.javaSerDes.add(this.getStringSerDes());
        this.javaSerDes.add(this.getBooleanSerDes());
        this.javaSerDes.add(this.getShortSerDes());
        this.javaSerDes.add(this.getIntegerSerDes());
        this.javaSerDes.add(this.getLongSerDes());
        this.javaSerDes.add(this.getFloatSerDes());
        this.javaSerDes.add(this.getDoubleSerDes());
        this.javaSerDes.add(this.getByteArraySerDes());
        this.javaSerDes.add(this.getByteBufferSerDes());
        this.javaSerDes.add(this.getUUIDSerDes());
    }

    @Override
    public byte[] serialize(@Nullable Object data, MutableBasicProperties properties) {
        if (data == null) {
            return null;
        }
        return this.findSerDes(Argument.of(data.getClass())).serialize(data, properties);
    }

    @Override
    public Object deserialize(RabbitConsumerState messageState, Argument<Object> argument) {
        Argument<Object> dataType = Collection.class.isAssignableFrom(argument.getType()) ? argument.getFirstTypeVariable().orElse(argument) : argument;
        return this.findSerDes(dataType).deserialize(messageState, argument);
    }

    @Override
    public boolean supports(Argument<Object> argument) {
        return this.findSerDes(argument) != null;
    }

    public int getOrder() {
        return ORDER;
    }

    @Nullable
    protected RabbitMessageSerDes findSerDes(Argument<?> type) {
        return this.javaSerDes.stream().filter(serDes -> serDes.supports(type)).findFirst().orElse(null);
    }

    @NonNull
    protected RabbitMessageSerDes<String> getStringSerDes() {
        return new StringSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<Short> getShortSerDes() {
        return new ShortSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<Integer> getIntegerSerDes() {
        return new IntegerSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<Long> getLongSerDes() {
        return new LongSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<Float> getFloatSerDes() {
        return new FloatSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<Double> getDoubleSerDes() {
        return new DoubleSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<byte[]> getByteArraySerDes() {
        return new ByteArraySerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<ByteBuffer> getByteBufferSerDes() {
        return new ByteBufferSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<UUID> getUUIDSerDes() {
        return new UUIDSerDes();
    }

    @NonNull
    protected RabbitMessageSerDes<Boolean> getBooleanSerDes() {
        return new BooleanSerDes();
    }

    static class StringSerDes
    implements RabbitMessageSerDes<String> {
        private static final Charset ENCODING = Charset.forName("UTF8");

        StringSerDes() {
        }

        @Override
        public String deserialize(RabbitConsumerState messageState, Argument<String> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            return new String(data, ENCODING);
        }

        @Override
        public byte[] serialize(String data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            return data.getBytes(ENCODING);
        }

        @Override
        public boolean supports(Argument<String> argument) {
            return argument.getType() == String.class;
        }
    }

    static class ShortSerDes
    implements RabbitMessageSerDes<Short> {
        ShortSerDes() {
        }

        @Override
        public Short deserialize(RabbitConsumerState messageState, Argument<Short> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 2) {
                throw new SerializationException("Incorrect message body size to deserialize to a Short");
            }
            short value = 0;
            for (byte b : data) {
                value = (short)(value << 8);
                value = (short)(value | b & 0xFF);
            }
            return value;
        }

        @Override
        public byte[] serialize(Short data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            return new byte[]{(byte)(data >>> 8), data.byteValue()};
        }

        @Override
        public boolean supports(Argument<Short> argument) {
            return argument.getType() == Short.class || argument.getType() == Short.TYPE;
        }
    }

    static class IntegerSerDes
    implements RabbitMessageSerDes<Integer> {
        IntegerSerDes() {
        }

        @Override
        public Integer deserialize(RabbitConsumerState messageState, Argument<Integer> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 4) {
                throw new SerializationException("Incorrect message body size to deserialize to an Integer");
            }
            int value = 0;
            for (byte b : data) {
                value <<= 8;
                value |= b & 0xFF;
            }
            return value;
        }

        @Override
        public byte[] serialize(Integer data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            return new byte[]{(byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), data.byteValue()};
        }

        @Override
        public boolean supports(Argument<Integer> argument) {
            return argument.getType() == Integer.class || argument.getType() == Integer.TYPE;
        }
    }

    static class LongSerDes
    implements RabbitMessageSerDes<Long> {
        LongSerDes() {
        }

        @Override
        public Long deserialize(RabbitConsumerState messageState, Argument<Long> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 8) {
                throw new SerializationException("Incorrect message body size to deserialize to a Long");
            }
            long value = 0L;
            for (byte b : data) {
                value <<= 8;
                value |= (long)(b & 0xFF);
            }
            return value;
        }

        @Override
        public byte[] serialize(Long data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            return new byte[]{(byte)(data >>> 56), (byte)(data >>> 48), (byte)(data >>> 40), (byte)(data >>> 32), (byte)(data >>> 24), (byte)(data >>> 16), (byte)(data >>> 8), data.byteValue()};
        }

        @Override
        public boolean supports(Argument<Long> argument) {
            return argument.getType() == Long.class || argument.getType() == Long.TYPE;
        }
    }

    static class FloatSerDes
    implements RabbitMessageSerDes<Float> {
        FloatSerDes() {
        }

        @Override
        public Float deserialize(RabbitConsumerState messageState, Argument<Float> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 4) {
                throw new SerializationException("Incorrect message body size to deserialize to a Float");
            }
            int value = 0;
            for (byte b : data) {
                value <<= 8;
                value |= b & 0xFF;
            }
            return Float.valueOf(Float.intBitsToFloat(value));
        }

        @Override
        public byte[] serialize(Float data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            long bits = Float.floatToRawIntBits(data.floatValue());
            return new byte[]{(byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
        }

        @Override
        public boolean supports(Argument<Float> argument) {
            return argument.getType() == Float.class || argument.getType() == Float.TYPE;
        }
    }

    static class DoubleSerDes
    implements RabbitMessageSerDes<Double> {
        DoubleSerDes() {
        }

        @Override
        public Double deserialize(RabbitConsumerState messageState, Argument<Double> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 8) {
                throw new SerializationException("Incorrect message body size to deserialize to a Double");
            }
            long value = 0L;
            for (byte b : data) {
                value <<= 8;
                value |= (long)(b & 0xFF);
            }
            return Double.longBitsToDouble(value);
        }

        @Override
        public byte[] serialize(Double data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            long bits = Double.doubleToLongBits(data);
            return new byte[]{(byte)(bits >>> 56), (byte)(bits >>> 48), (byte)(bits >>> 40), (byte)(bits >>> 32), (byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
        }

        @Override
        public boolean supports(Argument<Double> argument) {
            return argument.getType() == Double.class || argument.getType() == Double.TYPE;
        }
    }

    static class ByteArraySerDes
    implements RabbitMessageSerDes<byte[]> {
        ByteArraySerDes() {
        }

        @Override
        public byte[] deserialize(RabbitConsumerState messageState, Argument<byte[]> argument) {
            return messageState.getBody();
        }

        @Override
        public byte[] serialize(byte[] data, MutableBasicProperties properties) {
            return data;
        }

        @Override
        public boolean supports(Argument<byte[]> argument) {
            return argument.getType() == byte[].class;
        }
    }

    static class ByteBufferSerDes
    implements RabbitMessageSerDes<ByteBuffer> {
        ByteBufferSerDes() {
        }

        @Override
        public ByteBuffer deserialize(RabbitConsumerState messageState, Argument<ByteBuffer> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            return ByteBuffer.wrap(data);
        }

        @Override
        public byte[] serialize(ByteBuffer data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            data.rewind();
            if (data.hasArray()) {
                byte[] arr = data.array();
                if (data.arrayOffset() == 0 && arr.length == data.remaining()) {
                    return arr;
                }
            }
            byte[] ret = new byte[data.remaining()];
            data.get(ret, 0, ret.length);
            data.rewind();
            return ret;
        }

        @Override
        public boolean supports(Argument<ByteBuffer> argument) {
            return argument.getType() == ByteBuffer.class;
        }
    }

    static class UUIDSerDes
    implements RabbitMessageSerDes<UUID> {
        StringSerDes stringSerDes = new StringSerDes();

        UUIDSerDes() {
        }

        @Override
        public UUID deserialize(RabbitConsumerState messageState, Argument<UUID> argument) {
            Object uuid = this.stringSerDes.deserialize(messageState, Argument.of(String.class));
            if (uuid == null) {
                return null;
            }
            return UUID.fromString((String)uuid);
        }

        @Override
        public byte[] serialize(UUID data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            return this.stringSerDes.serialize(data.toString(), properties);
        }

        @Override
        public boolean supports(Argument<UUID> argument) {
            return argument.getType() == UUID.class;
        }
    }

    static class BooleanSerDes
    implements RabbitMessageSerDes<Boolean> {
        BooleanSerDes() {
        }

        @Override
        public Boolean deserialize(RabbitConsumerState messageState, Argument<Boolean> argument) {
            byte[] data = messageState.getBody();
            if (data == null || data.length == 0) {
                return null;
            }
            if (data.length != 1) {
                throw new SerializationException("Incorrect message body size to deserialize to a Boolean");
            }
            return data[0] != 0;
        }

        @Override
        public byte[] serialize(Boolean data, MutableBasicProperties properties) {
            if (data == null) {
                return null;
            }
            byte[] bytes = new byte[]{data != false ? (byte)1 : 0};
            return bytes;
        }

        @Override
        public boolean supports(Argument<Boolean> argument) {
            return argument.getType() == Boolean.class || argument.getType() == Boolean.TYPE;
        }
    }
}

