/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rss;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.rss.RssChannel;
import io.micronaut.rss.RssChannelImage;
import io.micronaut.rss.RssFeedRenderer;
import io.micronaut.rss.RssItem;
import io.micronaut.rss.RssItemEnclosure;
import io.micronaut.rss.RssSkipDays;
import io.micronaut.rss.RssSkipHours;
import io.micronaut.rss.RssTextInput;
import jakarta.inject.Singleton;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultRssFeedRenderer
implements RssFeedRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRssFeedRenderer.class);
    private static final String LOWER_THAN = "<";
    private static final String DESCRIPTION = "description";
    private static final String CATEGORY = "category";
    private static final String LANGUAGE = "language";
    private static final String COPYRIGHT = "copyright";
    private static final String PUB_DATE = "pubDate";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String TITLE = "title";
    private static final String LINK = "link";
    private static final String IMAGE = "image";
    private static final String URL = "url";
    private static final String SKIP_HOURS = "skipHours";
    private static final String HOUR = "hour";
    private static final String SKIP_DAYS = "skipDays";
    private static final String DAY = "day";
    private static final String TEXT_INPUT = "textInput";
    private static final String NAME = "name";
    private static final String ITEM = "item";
    private static final String RSS = "rss";
    private static final String CHANNEL = "channel";

    protected void writeElement(XMLStreamWriter sw, String localName, Object value) {
        block5: {
            try {
                sw.writeStartElement(localName);
                if (value instanceof String) {
                    sw.writeCharacters((String)value);
                } else if (value instanceof ZonedDateTime) {
                    DateTimeFormatter rfc822DateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z");
                    String pubDate = ((ZonedDateTime)value).format(rfc822DateFormat);
                    sw.writeCharacters(pubDate);
                }
                sw.writeEndElement();
            }
            catch (XMLStreamException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error(e.getMessage());
            }
        }
    }

    protected void writeRssItemDescription(XMLStreamWriter sw, RssItem rssItem) {
        rssItem.getDescription().ifPresent(description -> {
            if (this.shouldWrapDescriptionWithCData((String)description)) {
                try {
                    sw.writeStartElement(DESCRIPTION);
                    sw.writeCData((String)description);
                    sw.writeEndElement();
                }
                catch (XMLStreamException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(e.getMessage());
                    }
                }
            } else {
                this.writeElement(sw, DESCRIPTION, description);
            }
        });
    }

    protected boolean shouldWrapDescriptionWithCData(@NonNull String description) {
        return description.contains(LOWER_THAN);
    }

    protected void writeRssItem(XMLStreamWriter sw, RssItem rssItem) {
        block5: {
            try {
                rssItem.getTitle().ifPresent(title -> this.writeElement(sw, TITLE, title));
                rssItem.getLink().ifPresent(link -> this.writeElement(sw, LINK, link));
                this.writeRssItemDescription(sw, rssItem);
                rssItem.getAuthor().ifPresent(author -> this.writeElement(sw, "author", author));
                if (rssItem.getCategory().isPresent()) {
                    for (String category : rssItem.getCategory().get()) {
                        this.writeElement(sw, CATEGORY, category);
                    }
                }
                rssItem.getComments().ifPresent(comments -> this.writeElement(sw, "comments", comments));
                if (rssItem.getEnclosure().isPresent()) {
                    RssItemEnclosure enclosure = rssItem.getEnclosure().get();
                    sw.writeStartElement("enclosure");
                    sw.writeAttribute("length", String.valueOf(enclosure.getLength()));
                    sw.writeAttribute("type", enclosure.getType());
                    sw.writeAttribute(URL, enclosure.getUrl());
                    sw.writeEndElement();
                }
                rssItem.getGuid().ifPresent(guid -> this.writeElement(sw, "guid", guid));
                rssItem.getPubDate().ifPresent(pubDate -> this.writeElement(sw, PUB_DATE, pubDate));
                rssItem.getSource().ifPresent(source -> this.writeElement(sw, "source", source));
            }
            catch (XMLStreamException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error(e.getMessage());
            }
        }
    }

    protected Map<String, String> getRssAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("version", "2.0");
        m.put("xmlns:content", "http://purl.org/rss/1.0/modules/content/");
        return m;
    }

    protected void writeCategory(XMLStreamWriter sw, List<String> categories, String tagName) {
        block4: {
            if (!categories.isEmpty()) {
                try {
                    String category = categories.get(0);
                    sw.writeStartElement(tagName);
                    sw.writeAttribute("text", category);
                    if (categories.size() > 1) {
                        this.writeCategory(sw, categories.subList(1, categories.size()), tagName);
                    }
                    sw.writeEndElement();
                }
                catch (XMLStreamException e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    protected void writeRssChannel(XMLStreamWriter sw, RssChannel rssChannel) {
        block23: {
            block22: {
                block21: {
                    block20: {
                        this.writeElement(sw, TITLE, rssChannel.getTitle());
                        this.writeElement(sw, LINK, rssChannel.getLink());
                        if (rssChannel.getImage().isPresent()) {
                            try {
                                sw.writeStartElement(IMAGE);
                                RssChannelImage image = rssChannel.getImage().get();
                                this.writeElement(sw, TITLE, image.getTitle());
                                this.writeElement(sw, LINK, image.getLink());
                                this.writeElement(sw, URL, image.getUrl());
                                image.getWidth().ifPresent(width -> this.writeElement(sw, WIDTH, width));
                                image.getWidth().ifPresent(height -> this.writeElement(sw, HEIGHT, height));
                                image.getDescription().ifPresent(description -> this.writeElement(sw, DESCRIPTION, description));
                                sw.writeEndElement();
                            }
                            catch (XMLStreamException e) {
                                if (!LOG.isErrorEnabled()) break block20;
                                LOG.error(e.getMessage());
                            }
                        }
                    }
                    this.writeElement(sw, DESCRIPTION, rssChannel.getDescription());
                    rssChannel.getLanguage().ifPresent(language -> this.writeElement(sw, LANGUAGE, language.getLanguageCode()));
                    rssChannel.getCopyright().ifPresent(copyright -> this.writeElement(sw, COPYRIGHT, copyright));
                    rssChannel.getPubDate().ifPresent(pubDate -> this.writeElement(sw, PUB_DATE, pubDate));
                    if (rssChannel.getCategory().isPresent()) {
                        for (List<String> categoryList : rssChannel.getCategory().get()) {
                            this.writeCategory(sw, categoryList, CATEGORY);
                        }
                    }
                    if (rssChannel.getSkipHours().isPresent()) {
                        try {
                            sw.writeStartElement(SKIP_HOURS);
                            for (RssSkipHours skipHours : rssChannel.getSkipHours().get()) {
                                this.writeElement(sw, HOUR, String.valueOf(skipHours.getValue()));
                            }
                            sw.writeEndElement();
                        }
                        catch (XMLStreamException e) {
                            if (!LOG.isErrorEnabled()) break block21;
                            LOG.error(e.getMessage());
                        }
                    }
                }
                if (rssChannel.getSkipDays().isPresent()) {
                    try {
                        sw.writeStartElement(SKIP_DAYS);
                        for (RssSkipDays skipDay : rssChannel.getSkipDays().get()) {
                            this.writeElement(sw, DAY, String.valueOf(skipDay.getDayName()));
                        }
                        sw.writeEndElement();
                    }
                    catch (XMLStreamException e) {
                        if (!LOG.isErrorEnabled()) break block22;
                        LOG.error(e.getMessage());
                    }
                }
            }
            if (rssChannel.getTextInput().isPresent()) {
                RssTextInput textInput = rssChannel.getTextInput().get();
                try {
                    sw.writeStartElement(TEXT_INPUT);
                    this.writeElement(sw, TITLE, textInput.getTitle());
                    this.writeElement(sw, NAME, textInput.getName());
                    this.writeElement(sw, LINK, textInput.getLink());
                    this.writeElement(sw, DESCRIPTION, textInput.getDescription());
                    sw.writeEndElement();
                }
                catch (XMLStreamException e) {
                    if (!LOG.isErrorEnabled()) break block23;
                    LOG.error(e.getMessage());
                }
            }
        }
        if (rssChannel.getItem().isPresent()) {
            for (RssItem rssItem : rssChannel.getItem().get()) {
                try {
                    sw.writeStartElement(ITEM);
                    this.writeRssItem(sw, rssItem);
                    sw.writeEndElement();
                }
                catch (XMLStreamException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public void render(Writer writer, RssChannel rssChannel) {
        block4: {
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
            try {
                XMLStreamWriter sw = xmlOutputFactory.createXMLStreamWriter(writer);
                if (sw != null && rssChannel != null) {
                    sw.writeStartDocument("UTF-8", "1.0");
                    sw.writeStartElement(RSS);
                    for (String key : this.getRssAttributes().keySet()) {
                        sw.writeAttribute(key, this.getRssAttributes().get(key));
                    }
                    sw.writeStartElement(CHANNEL);
                    this.writeRssChannel(sw, rssChannel);
                    sw.writeEndElement();
                    sw.writeEndElement();
                    sw.writeEndDocument();
                }
            }
            catch (XMLStreamException e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error(e.getMessage());
            }
        }
    }
}

