/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rss;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.rss.RssChannelImage;
import io.micronaut.rss.RssItem;
import io.micronaut.rss.RssSkipDays;
import io.micronaut.rss.RssSkipHours;
import io.micronaut.rss.RssTextInput;
import io.micronaut.rss.language.RssLanguage;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class RssChannel {
    @NotBlank
    @NotNull
    private String title;
    @NotBlank
    @NotNull
    private String link;
    @NotBlank
    @NotNull
    private String description;
    @Pattern(regexp="af|sq|eu|be|bg|ca|zh-cn|zh-tw|hr|cs|da|nl|nl-be|nl-nl|en|en-au|en-bz|en-ca|en-ie|en-jm|en-nz|en-ph|en-za|en-tt|en-gb|en-us|en-zw|et|fo|fi|fr|fr-be|fr-ca|fr-fr|fr-lu|fr-mc|fr-ch|gl|gd|de|de-at|de-de|de-li|de-lu|de-ch|el|haw|hu|is|in|ga|it|it-it|it-ch|ja|ko|mk|no|pl|pt|pt-br|pt-pt|ro|ro-mo|ro-ro|ru|ru-mo|ru-ru|sr|sk|sl|es|es-ar|es-bo|es-cl|es-co|es-cr|es-do|es-ec|es-sv|es-gt|es-hn|es-mx|es-ni|es-pa|es-py|es-pe|es-pr|es-es|es-uy|es-ve|sv|sv-fi|sv-se|tr|uk")
    @Nullable
    private @Pattern(regexp="af|sq|eu|be|bg|ca|zh-cn|zh-tw|hr|cs|da|nl|nl-be|nl-nl|en|en-au|en-bz|en-ca|en-ie|en-jm|en-nz|en-ph|en-za|en-tt|en-gb|en-us|en-zw|et|fo|fi|fr|fr-be|fr-ca|fr-fr|fr-lu|fr-mc|fr-ch|gl|gd|de|de-at|de-de|de-li|de-lu|de-ch|el|haw|hu|is|in|ga|it|it-it|it-ch|ja|ko|mk|no|pl|pt|pt-br|pt-pt|ro|ro-mo|ro-ro|ru|ru-mo|ru-ru|sr|sk|sl|es|es-ar|es-bo|es-cl|es-co|es-cr|es-do|es-ec|es-sv|es-gt|es-hn|es-mx|es-ni|es-pa|es-py|es-pe|es-pr|es-es|es-uy|es-ve|sv|sv-fi|sv-se|tr|uk") RssLanguage language;
    @Nullable
    private String copyright;
    @Nullable
    private String managingEditor;
    @Nullable
    private String webMaster;
    @Nullable
    private ZonedDateTime pubDate;
    @Nullable
    private ZonedDateTime lastBuildDate;
    @Nullable
    private List<List<String>> category = new ArrayList<List<String>>();
    @Nullable
    private String generator;
    @Nullable
    private String docs;
    @Nullable
    private String cloud;
    @Positive
    @Nullable
    private Integer ttl;
    @Nullable
    private RssChannelImage image;
    @Nullable
    private String rating;
    @Nullable
    private RssTextInput textInput;
    @Nullable
    private List<RssSkipHours> skipHours;
    @Nullable
    private List<RssSkipDays> skipDays;
    @Nullable
    private List<RssItem> item = new ArrayList<RssItem>();

    public String getTitle() {
        return this.title;
    }

    public String getLink() {
        return this.link;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<RssLanguage> getLanguage() {
        if (this.language == null) {
            return Optional.empty();
        }
        return RssLanguage.of((String)this.language.getLanguageCode());
    }

    public Optional<String> getCopyright() {
        if (this.copyright == null) {
            return Optional.empty();
        }
        return Optional.of(this.copyright);
    }

    public Optional<String> getManagingEditor() {
        if (this.managingEditor == null) {
            return Optional.empty();
        }
        return Optional.of(this.managingEditor);
    }

    public Optional<String> getWebMaster() {
        if (this.webMaster == null) {
            return Optional.empty();
        }
        return Optional.of(this.webMaster);
    }

    public Optional<ZonedDateTime> getPubDate() {
        if (this.pubDate == null) {
            return Optional.empty();
        }
        return Optional.of(this.pubDate);
    }

    public Optional<ZonedDateTime> getLastBuildDate() {
        if (this.lastBuildDate == null) {
            return Optional.empty();
        }
        return Optional.of(this.lastBuildDate);
    }

    public Optional<List<List<String>>> getCategory() {
        if (this.category == null) {
            return Optional.empty();
        }
        return Optional.of(this.category);
    }

    public Optional<String> getGenerator() {
        if (this.generator == null) {
            return Optional.empty();
        }
        return Optional.of(this.generator);
    }

    public Optional<String> getDocs() {
        if (this.docs == null) {
            return Optional.empty();
        }
        return Optional.of(this.docs);
    }

    public Optional<String> getCloud() {
        if (this.cloud == null) {
            return Optional.empty();
        }
        return Optional.of(this.cloud);
    }

    public Optional<Integer> getTtl() {
        if (this.ttl == null) {
            return Optional.empty();
        }
        return Optional.of(this.ttl);
    }

    public Optional<RssChannelImage> getImage() {
        if (this.image == null) {
            return Optional.empty();
        }
        return Optional.of(this.image);
    }

    public Optional<String> getRating() {
        if (this.rating == null) {
            return Optional.empty();
        }
        return Optional.of(this.rating);
    }

    public Optional<RssTextInput> getTextInput() {
        if (this.textInput == null) {
            return Optional.empty();
        }
        return Optional.of(this.textInput);
    }

    public Optional<List<RssSkipHours>> getSkipHours() {
        if (this.skipHours == null) {
            return Optional.empty();
        }
        return Optional.of(this.skipHours);
    }

    public Optional<List<RssSkipDays>> getSkipDays() {
        if (this.skipDays == null) {
            return Optional.empty();
        }
        return Optional.of(this.skipDays);
    }

    public Optional<List<RssItem>> getItem() {
        if (this.item == null) {
            return Optional.empty();
        }
        return Optional.of(this.item);
    }

    public void addItem(RssItem item) {
        if (item != null) {
            this.item.add(item);
        }
    }

    public void setSkipDays(List<RssSkipDays> skipDays) {
        this.skipDays = skipDays;
    }

    public void setSkipHours(List<RssSkipHours> skipHours) {
        this.skipHours = skipHours;
    }

    public void setTextInput(RssTextInput textInput) {
        this.textInput = textInput;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public void setImage(RssChannelImage image) {
        this.image = image;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public void setDocs(String docs) {
        this.docs = docs;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public void setCategory(List<List<String>> category) {
        this.category = category;
    }

    public void setLastBuildDate(ZonedDateTime lastBuildDate) {
        this.lastBuildDate = lastBuildDate;
    }

    public void setPubDate(ZonedDateTime pubDate) {
        this.pubDate = pubDate;
    }

    public void setWebMaster(String webMaster) {
        this.webMaster = webMaster;
    }

    public void setManagingEditor(String managingEditor) {
        this.managingEditor = managingEditor;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setLanguage(RssLanguage language) {
        this.language = language;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setItem(List<RssItem> item) {
        this.item = item;
    }

    public static Builder builder(String title, String link, String description) {
        return new Builder(title, link, description);
    }

    public static final class Builder {
        private RssChannel rssChannel = new RssChannel();

        private Builder(String title, String link, String description) {
            this.rssChannel.setTitle(title);
            this.rssChannel.setLink(link);
            this.rssChannel.setDescription(description);
        }

        @NonNull
        public Builder language(RssLanguage language) {
            this.rssChannel.setLanguage(language);
            return this;
        }

        @NonNull
        public Builder copyright(String copyright) {
            this.rssChannel.setCopyright(copyright);
            return this;
        }

        @NonNull
        public Builder managingEditor(String managingEditor) {
            this.rssChannel.setManagingEditor(managingEditor);
            return this;
        }

        @NonNull
        public Builder webMaster(String webMaster) {
            this.rssChannel.setWebMaster(webMaster);
            return this;
        }

        @NonNull
        public Builder pubDate(ZonedDateTime pubDate) {
            this.rssChannel.setPubDate(pubDate);
            return this;
        }

        @NonNull
        public Builder lastBuildDate(ZonedDateTime lastBuildDate) {
            this.rssChannel.setLastBuildDate(lastBuildDate);
            return this;
        }

        @NonNull
        public Builder category(List<List<String>> category) {
            this.rssChannel.setCategory(category);
            return this;
        }

        @NonNull
        public Builder generator(String generator) {
            this.rssChannel.setGenerator(generator);
            return this;
        }

        @NonNull
        public Builder docs(String docs) {
            this.rssChannel.setDocs(docs);
            return this;
        }

        @NonNull
        public Builder cloud(String cloud) {
            this.rssChannel.setCloud(cloud);
            return this;
        }

        @NonNull
        public Builder ttl(Integer ttl) {
            this.rssChannel.setTtl(ttl);
            return this;
        }

        @NonNull
        public Builder image(RssChannelImage image) {
            this.rssChannel.setImage(image);
            return this;
        }

        @NonNull
        public Builder rating(String rating) {
            this.rssChannel.setRating(rating);
            return this;
        }

        @NonNull
        public Builder textInput(RssTextInput textInput) {
            this.rssChannel.setTextInput(textInput);
            return this;
        }

        @NonNull
        public Builder skipHours(List<RssSkipHours> skipHours) {
            this.rssChannel.setSkipHours(skipHours);
            return this;
        }

        @NonNull
        public Builder skipDays(List<RssSkipDays> skipDays) {
            this.rssChannel.setSkipDays(skipDays);
            return this;
        }

        @NonNull
        public Builder item(RssItem item) {
            if (this.rssChannel.getItem().isPresent()) {
                this.rssChannel.addItem(item);
            } else {
                this.rssChannel.setItem(Arrays.asList(item));
            }
            return this;
        }

        @NonNull
        public RssChannel build() {
            return this.rssChannel;
        }
    }
}

