/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rss;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Optional;

public class RssChannelImage {
    private String url;
    private String title;
    private String link;
    @Nullable
    private Integer width;
    @Nullable
    private Integer height;
    @Nullable
    private String description;

    public Optional<Integer> getWidth() {
        if (this.width == null) {
            return Optional.empty();
        }
        return Optional.of(this.width);
    }

    public Optional<Integer> getHeight() {
        if (this.height == null) {
            return Optional.empty();
        }
        return Optional.of(this.height);
    }

    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static Builder builder(String title, String url, String link) {
        return new Builder(title, url, link);
    }

    public void setWidth(@Nullable Integer width) {
        this.width = width;
    }

    public void setHeight(@Nullable Integer height) {
        this.height = height;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public static final class Builder {
        RssChannelImage image = new RssChannelImage();

        private Builder(String title, String url, String link) {
            this.image.setTitle(title);
            this.image.setUrl(url);
            this.image.setLink(link);
        }

        public Builder width(Integer width) {
            this.image.setWidth(width);
            return this;
        }

        public Builder height(Integer height) {
            this.image.setHeight(height);
            return this;
        }

        public Builder description(String description) {
            this.image.setDescription(description);
            return this;
        }

        @NonNull
        public RssChannelImage build() {
            return this.image;
        }
    }
}

