/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rss;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.rss.RssItemEnclosure;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;

public class RssItem {
    @Nullable
    private String title;
    @Nullable
    private String link;
    @Nullable
    private String description;
    @Nullable
    private String author;
    @Nullable
    private List<String> category;
    @Nullable
    private String comments;
    @Nullable
    private RssItemEnclosure enclosure;
    @Nullable
    private ZonedDateTime pubDate;
    @Nullable
    private String guid;
    @Nullable
    private String source;

    public Optional<String> getTitle() {
        if (this.title == null) {
            return Optional.empty();
        }
        return Optional.of(this.title);
    }

    public Optional<String> getLink() {
        if (this.link == null) {
            return Optional.empty();
        }
        return Optional.of(this.link);
    }

    public Optional<String> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    public Optional<String> getAuthor() {
        if (this.author == null) {
            return Optional.empty();
        }
        return Optional.of(this.author);
    }

    public Optional<List<String>> getCategory() {
        if (this.category == null) {
            return Optional.empty();
        }
        return Optional.of(this.category);
    }

    public Optional<String> getComments() {
        if (this.comments == null) {
            return Optional.empty();
        }
        return Optional.of(this.comments);
    }

    public Optional<RssItemEnclosure> getEnclosure() {
        if (this.enclosure == null) {
            return Optional.empty();
        }
        return Optional.of(this.enclosure);
    }

    public Optional<String> getGuid() {
        if (this.guid == null) {
            return Optional.empty();
        }
        return Optional.of(this.guid);
    }

    public Optional<ZonedDateTime> getPubDate() {
        if (this.pubDate == null) {
            return Optional.empty();
        }
        return Optional.of(this.pubDate);
    }

    public Optional<String> getSource() {
        if (this.source == null) {
            return Optional.empty();
        }
        return Optional.of(this.source);
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public void setLink(@Nullable String link) {
        this.link = link;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setAuthor(@Nullable String author) {
        this.author = author;
    }

    public void setCategory(@Nullable List<String> category) {
        this.category = category;
    }

    public void setComments(@Nullable String comments) {
        this.comments = comments;
    }

    public void setEnclosure(@Nullable RssItemEnclosure enclosure) {
        this.enclosure = enclosure;
    }

    public void setPubDate(@Nullable ZonedDateTime pubDate) {
        this.pubDate = pubDate;
    }

    public void setGuid(@Nullable String guid) {
        this.guid = guid;
    }

    public void setSource(@Nullable String source) {
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RssItem rssItem = new RssItem();

        private Builder() {
        }

        @NonNull
        public Builder title(String title) {
            this.rssItem.setTitle(title);
            return this;
        }

        @NonNull
        public Builder link(String link) {
            this.rssItem.setLink(link);
            return this;
        }

        @NonNull
        public Builder description(String description) {
            this.rssItem.setDescription(description);
            return this;
        }

        @NonNull
        public Builder author(String author) {
            this.rssItem.setAuthor(author);
            return this;
        }

        @NonNull
        public Builder category(List<String> category) {
            this.rssItem.setCategory(category);
            return this;
        }

        @NonNull
        public Builder comments(String comments) {
            this.rssItem.setComments(comments);
            return this;
        }

        @NonNull
        public Builder enclosure(RssItemEnclosure enclosure) {
            this.rssItem.setEnclosure(enclosure);
            return this;
        }

        @NonNull
        public Builder pubDate(ZonedDateTime pubDate) {
            this.rssItem.setPubDate(pubDate);
            return this;
        }

        @NonNull
        public Builder guid(String guid) {
            this.rssItem.setGuid(guid);
            return this;
        }

        @NonNull
        public Builder source(String source) {
            this.rssItem.setSource(source);
            return this;
        }

        @NonNull
        public RssItem build() {
            return this.rssItem;
        }
    }
}

