/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.request;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.OauthAuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceChallenge;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceFactory;
import io.micronaut.security.oauth2.endpoint.authorization.request.OauthAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.ResponseType;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateFactory;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Prototype
@Internal
class DefaultOauthAuthorizationRequest
implements OauthAuthorizationRequest {
    private final HttpRequest<?> request;
    private final OauthClientConfiguration oauthClientConfiguration;
    private final OauthRouteUrlBuilder oauthRouteUrlBuilder;
    private final StateFactory stateFactory;
    private final PkceFactory pkceFactory;

    DefaultOauthAuthorizationRequest(@Parameter HttpRequest<?> request, @Parameter OauthClientConfiguration oauthClientConfiguration, OauthRouteUrlBuilder oauthRouteUrlBuilder, @Nullable StateFactory stateFactory, @Nullable PkceFactory pkceFactory) {
        this.request = request;
        this.oauthClientConfiguration = oauthClientConfiguration;
        this.oauthRouteUrlBuilder = oauthRouteUrlBuilder;
        this.stateFactory = stateFactory;
        this.pkceFactory = pkceFactory;
    }

    @Override
    @NonNull
    public String getClientId() {
        return this.oauthClientConfiguration.getClientId();
    }

    public Optional<String> getState(MutableHttpResponse response) {
        return Optional.ofNullable(this.stateFactory).map(sf -> sf.buildState(this.request, response, this));
    }

    @Override
    @NonNull
    public Optional<PkceChallenge> getPkceChallenge(@NonNull MutableHttpResponse<?> response) {
        return this.oauthClientConfiguration.getAuthorization().flatMap(OauthAuthorizationEndpointConfiguration::getCodeChallengeMethod).flatMap(codeChallengeMethod -> this.pkceFactory == null ? Optional.empty() : this.pkceFactory.buildChallenge(this.request, response, Collections.singletonList(codeChallengeMethod)).map(PkceChallenge.class::cast));
    }

    @Override
    @NonNull
    public List<String> getScopes() {
        return this.oauthClientConfiguration.getScopes();
    }

    @Override
    @NonNull
    public String getResponseType() {
        return ResponseType.CODE.toString();
    }

    @Override
    public Optional<String> getRedirectUri() {
        return Optional.of(this.oauthRouteUrlBuilder.buildCallbackUrl(this.request, this.oauthClientConfiguration.getName()).toString());
    }
}

