/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.context;

import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.token.request.context.AbstractTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.TokenErrorResponse;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import io.micronaut.security.oauth2.grants.ClientCredentialsGrant;
import java.util.Collections;
import java.util.Map;

public class ClientCredentialsTokenRequestContext
extends AbstractTokenRequestContext<Map<String, String>, TokenResponse> {
    private final ClientCredentialsGrant grant;
    private final Map<String, String> additionalRequestParams;

    public ClientCredentialsTokenRequestContext(String scope, SecureEndpoint tokenEndpoint, OauthClientConfiguration clientConfiguration) {
        super(MediaType.APPLICATION_FORM_URLENCODED_TYPE, tokenEndpoint, clientConfiguration);
        ClientCredentialsGrant clientCredentialsGrant = new ClientCredentialsGrant();
        clientCredentialsGrant.setScope(scope);
        this.grant = clientCredentialsGrant;
        this.additionalRequestParams = clientConfiguration.getClientCredentials().map(ClientCredentialsConfiguration::getAdditionalRequestParams).orElseGet(Collections::emptyMap);
    }

    public ClientCredentialsTokenRequestContext(OauthClientConfiguration clientConfiguration) {
        super(MediaType.APPLICATION_FORM_URLENCODED_TYPE, clientConfiguration.getTokenEndpoint(), clientConfiguration);
        this.grant = new ClientCredentialsGrant();
        this.additionalRequestParams = clientConfiguration.getClientCredentials().map(ClientCredentialsConfiguration::getAdditionalRequestParams).orElseGet(Collections::emptyMap);
    }

    public ClientCredentialsTokenRequestContext(String scope, OauthClientConfiguration clientConfiguration) {
        super(MediaType.APPLICATION_FORM_URLENCODED_TYPE, clientConfiguration.getTokenEndpoint(), clientConfiguration);
        this.grant = new ClientCredentialsGrant();
        this.grant.setScope(scope);
        this.additionalRequestParams = clientConfiguration.getClientCredentials().map(ClientCredentialsConfiguration::getAdditionalRequestParams).orElseGet(Collections::emptyMap);
    }

    @Override
    public Map<String, String> getGrant() {
        Map<String, String> grantMap = this.grant.toMap();
        grantMap.putAll(this.additionalRequestParams);
        return grantMap;
    }

    @Override
    public Argument<TokenResponse> getResponseType() {
        return Argument.of(TokenResponse.class);
    }

    @Override
    public Argument<?> getErrorResponseType() {
        return Argument.of(TokenErrorResponse.class);
    }
}

