/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.grants.AbstractClientSecureGrant;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.GrantType;
import io.micronaut.security.oauth2.grants.SecureGrant;
import java.util.Map;

@Introspected
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class PasswordGrant
extends AbstractClientSecureGrant
implements SecureGrant,
AsMap {
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_SCOPE = "scope";
    private String grantType = GrantType.PASSWORD.toString();
    private String username;
    private String password;
    private String scope;

    public PasswordGrant(AuthenticationRequest authenticationRequest, OauthClientConfiguration clientConfiguration) {
        this.username = authenticationRequest.getIdentity().toString();
        this.password = authenticationRequest.getSecret().toString();
        this.scope = clientConfiguration.getScopes().stream().reduce((a, b) -> a + " " + b).orElse(null);
    }

    @Override
    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public void setGrantType(@NonNull String grantType) {
        this.grantType = grantType;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@NonNull String username) {
        this.username = username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    public void setPassword(@NonNull String password) {
        this.password = password;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(@NonNull String scope) {
        this.scope = scope;
    }

    @Override
    @NonNull
    public Map<String, String> toMap() {
        Map<String, String> m = super.toMap();
        m.put(KEY_USERNAME, this.username);
        m.put(KEY_PASSWORD, this.password);
        if (StringUtils.isNotEmpty((CharSequence)this.scope)) {
            m.put(KEY_SCOPE, this.scope);
        }
        return m;
    }
}

