/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.routes;

import io.micronaut.context.BeanContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.ProviderResolver;
import io.micronaut.security.oauth2.client.OpenIdClient;
import io.micronaut.security.oauth2.routes.EndSessionController;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultEndSessionController
implements EndSessionController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEndSessionController.class);
    private final ProviderResolver providerResolver;
    private final BeanContext beanContext;

    public DefaultEndSessionController(ProviderResolver providerResolver, BeanContext beanContext) {
        this.providerResolver = providerResolver;
        this.beanContext = beanContext;
    }

    @Override
    public Optional<MutableHttpResponse<?>> endSession(HttpRequest<?> request, Authentication authentication) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received logout request for user [{}]", (Object)authentication.getName());
        }
        return this.providerResolver.resolveProvider(authentication).flatMap(p -> this.beanContext.findBean(OpenIdClient.class, Qualifiers.byName((String)p))).filter(OpenIdClient::supportsEndSession).flatMap(c -> c.endSessionRedirect(request, authentication));
    }
}

