/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.javapoet.AnnotationSpec;
import io.micronaut.sourcegen.javapoet.ArrayTypeName;
import io.micronaut.sourcegen.javapoet.ClassName;
import io.micronaut.sourcegen.javapoet.CodeBlock;
import io.micronaut.sourcegen.javapoet.FieldSpec;
import io.micronaut.sourcegen.javapoet.JavaFile;
import io.micronaut.sourcegen.javapoet.MethodSpec;
import io.micronaut.sourcegen.javapoet.ParameterSpec;
import io.micronaut.sourcegen.javapoet.ParameterizedTypeName;
import io.micronaut.sourcegen.javapoet.TypeName;
import io.micronaut.sourcegen.javapoet.TypeSpec;
import io.micronaut.sourcegen.javapoet.TypeVariableName;
import io.micronaut.sourcegen.javapoet.Util;
import io.micronaut.sourcegen.javapoet.WildcardTypeName;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.InterfaceDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.lang.model.element.Modifier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public class JavaPoetSourceGenerator
implements SourceGenerator {
    public VisitorContext.Language getLanguage() {
        return VisitorContext.Language.JAVA;
    }

    public void write(ObjectDef objectDef, Writer writer) throws IOException {
        if (objectDef instanceof ClassDef) {
            ClassDef classDef = (ClassDef)objectDef;
            this.writeClass(writer, classDef);
        } else if (objectDef instanceof RecordDef) {
            RecordDef recordDef = (RecordDef)objectDef;
            this.writeRecord(writer, recordDef);
        } else if (objectDef instanceof InterfaceDef) {
            InterfaceDef interfaceDef = (InterfaceDef)objectDef;
            this.writeInterface(writer, interfaceDef);
        } else if (objectDef instanceof EnumDef) {
            EnumDef enumDef = (EnumDef)objectDef;
            this.writeEnum(writer, enumDef);
        } else {
            throw new IllegalStateException("Unknown object definition: " + objectDef);
        }
    }

    private void writeInterface(Writer writer, InterfaceDef interfaceDef) throws IOException {
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder(interfaceDef.getSimpleName());
        interfaceBuilder.addModifiers(interfaceDef.getModifiersArray());
        interfaceDef.getTypeVariables().stream().map(t -> this.asTypeVariable((TypeDef.TypeVariable)t, (ObjectDef)interfaceDef)).forEach(interfaceBuilder::addTypeVariable);
        interfaceDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)interfaceDef)).forEach(interfaceBuilder::addSuperinterface);
        interfaceDef.getJavadoc().forEach(interfaceBuilder::addJavadoc);
        for (AnnotationDef annotation : interfaceDef.getAnnotations()) {
            interfaceBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (PropertyDef property : interfaceDef.getProperties()) {
            TypeName propertyType = this.asType(property.getType(), (ObjectDef)interfaceDef);
            String propertyName = property.getName();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(propertyType, propertyName, new Modifier[0]).addModifiers(Modifier.PRIVATE);
            property.getJavadoc().forEach(x$0 -> fieldBuilder.addJavadoc((String)x$0, new Object[0]));
            for (AnnotationDef annotation : property.getAnnotations()) {
                fieldBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            interfaceBuilder.addField(fieldBuilder.build());
            String capitalizedPropertyName = NameUtils.capitalize((String)propertyName);
            interfaceBuilder.addMethod(MethodSpec.methodBuilder("get" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).returns(propertyType).build());
            interfaceBuilder.addMethod(MethodSpec.methodBuilder("set" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).addParameter(ParameterSpec.builder(propertyType, propertyName, new Modifier[0]).build()).build());
        }
        for (MethodDef method : interfaceDef.getMethods()) {
            interfaceBuilder.addMethod(this.asMethodSpec((ObjectDef)interfaceDef, method));
        }
        JavaFile javaFile = JavaFile.builder(interfaceDef.getPackageName(), interfaceBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private void writeEnum(Writer writer, EnumDef enumDef) throws IOException {
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder(enumDef.getSimpleName());
        enumBuilder.addModifiers(enumDef.getModifiersArray());
        enumDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)enumDef)).forEach(enumBuilder::addSuperinterface);
        enumDef.getJavadoc().forEach(enumBuilder::addJavadoc);
        for (AnnotationDef annotation : enumDef.getAnnotations()) {
            enumBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (String enumConstant : enumDef.getEnumConstants()) {
            enumBuilder.addEnumConstant(enumConstant);
        }
        for (MethodDef method : enumDef.getMethods()) {
            enumBuilder.addMethod(this.asMethodSpec((ObjectDef)enumDef, method));
        }
        JavaFile javaFile = JavaFile.builder(enumDef.getPackageName(), enumBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private void writeClass(Writer writer, ClassDef classDef) throws IOException {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(classDef.getSimpleName());
        ClassTypeDef thisType = classDef.asTypeDef();
        classBuilder.addModifiers(classDef.getModifiersArray());
        classDef.getTypeVariables().stream().map(t -> this.asTypeVariable((TypeDef.TypeVariable)t, (ObjectDef)classDef)).forEach(classBuilder::addTypeVariable);
        classDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)classDef)).forEach(classBuilder::addSuperinterface);
        classDef.getJavadoc().forEach(classBuilder::addJavadoc);
        if (classDef.getSuperclass() != null) {
            classBuilder.superclass(this.asType((TypeDef)classDef.getSuperclass(), (ObjectDef)classDef));
        }
        for (AnnotationDef annotation : classDef.getAnnotations()) {
            classBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (PropertyDef property : classDef.getProperties()) {
            TypeName propertyType = this.asType(property.getType(), (ObjectDef)classDef);
            String propertyName = property.getName();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(propertyType, propertyName, new Modifier[0]).addModifiers(Modifier.PRIVATE);
            for (AnnotationDef annotation : property.getAnnotations()) {
                fieldBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            property.getJavadoc().forEach(x$0 -> fieldBuilder.addJavadoc((String)x$0, new Object[0]));
            classBuilder.addField(fieldBuilder.build());
            String capitalizedPropertyName = NameUtils.capitalize((String)propertyName);
            classBuilder.addMethod(MethodSpec.methodBuilder("get" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).returns(propertyType).addStatement("return this." + propertyName, new Object[0]).build());
            classBuilder.addMethod(MethodSpec.methodBuilder("set" + capitalizedPropertyName).addModifiers(property.getModifiersArray()).addParameter(ParameterSpec.builder(propertyType, propertyName, new Modifier[0]).build()).addStatement("this." + propertyName + " = " + propertyName, new Object[0]).build());
        }
        for (FieldDef field : classDef.getFields()) {
            FieldSpec.Builder fieldBuilder = FieldSpec.builder(this.asType(field.getType(), (ObjectDef)classDef), field.getName(), new Modifier[0]).addModifiers(field.getModifiersArray());
            field.getInitializer().ifPresent(init -> fieldBuilder.initializer(this.renderExpression(null, null, (ExpressionDef)init)));
            field.getJavadoc().forEach(x$0 -> fieldBuilder.addJavadoc((String)x$0, new Object[0]));
            for (AnnotationDef annotation : field.getAnnotations()) {
                fieldBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            classBuilder.addField(fieldBuilder.build());
        }
        for (MethodDef method : classDef.getMethods()) {
            classBuilder.addMethod(this.asMethodSpec((ObjectDef)classDef, method));
        }
        JavaFile javaFile = JavaFile.builder(classDef.getPackageName(), classBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private void writeRecord(Writer writer, RecordDef recordDef) throws IOException {
        TypeSpec.Builder classBuilder = TypeSpec.recordBuilder(recordDef.getSimpleName());
        classBuilder.addModifiers(recordDef.getModifiersArray());
        recordDef.getTypeVariables().stream().map(t -> this.asTypeVariable((TypeDef.TypeVariable)t, (ObjectDef)recordDef)).forEach(classBuilder::addTypeVariable);
        recordDef.getSuperinterfaces().stream().map(typeDef -> this.asType((TypeDef)typeDef, (ObjectDef)recordDef)).forEach(classBuilder::addSuperinterface);
        recordDef.getJavadoc().forEach(classBuilder::addJavadoc);
        for (AnnotationDef annotation : recordDef.getAnnotations()) {
            classBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        for (PropertyDef property : recordDef.getProperties()) {
            TypeName propertyType = this.asType(property.getType(), (ObjectDef)recordDef);
            String propertyName = property.getName();
            ParameterSpec.Builder componentBuilder = ParameterSpec.builder(propertyType, propertyName, new Modifier[0]);
            property.getJavadoc().forEach(componentBuilder::addJavadoc);
            for (AnnotationDef annotation : property.getAnnotations()) {
                componentBuilder.addAnnotation(this.asAnnotationSpec(annotation));
            }
            classBuilder.addRecordComponent(componentBuilder.build());
        }
        for (MethodDef method : recordDef.getMethods()) {
            classBuilder.addMethod(this.asMethodSpec((ObjectDef)recordDef, method));
        }
        JavaFile javaFile = JavaFile.builder(recordDef.getPackageName(), classBuilder.build()).build();
        javaFile.writeTo(writer);
    }

    private MethodSpec asMethodSpec(ObjectDef objectDef, MethodDef method) {
        String methodName = method.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(methodName).addModifiers(method.getModifiersArray()).addParameters(method.getParameters().stream().map(param -> ParameterSpec.builder(this.asType(param.getType(), objectDef), param.getName(), param.getModifiersArray()).addAnnotations(param.getAnnotations().stream().map(this::asAnnotationSpec).toList()).build()).toList());
        if (!methodName.equals("<init>")) {
            methodBuilder.returns(this.asType(method.getReturnType(), objectDef));
        }
        method.getJavadoc().forEach(x$0 -> methodBuilder.addJavadoc((String)x$0, new Object[0]));
        for (AnnotationDef annotation : method.getAnnotations()) {
            methodBuilder.addAnnotation(this.asAnnotationSpec(annotation));
        }
        method.getStatements().stream().map(st -> this.renderStatementCodeBlock(objectDef, method, (StatementDef)st)).forEach(methodBuilder::addCode);
        return methodBuilder.build();
    }

    private TypeVariableName asTypeVariable(TypeDef.TypeVariable tv, ObjectDef objectDef) {
        return TypeVariableName.get(tv.name(), (TypeName[])tv.bounds().stream().map(t -> this.asType((TypeDef)t, objectDef)).toArray(TypeName[]::new));
    }

    private AnnotationSpec asAnnotationSpec(AnnotationDef annotationDef) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder(ClassName.bestGuess(annotationDef.getType().getName()));
        for (Map.Entry e : annotationDef.getValues().entrySet()) {
            this.addAnnotationValue(builder, (String)e.getKey(), e.getValue());
        }
        return builder.build();
    }

    private void addAnnotationValue(AnnotationSpec.Builder builder, String memberName, Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            collection.forEach(v -> this.addAnnotationValue(builder, memberName, v));
        } else if (value instanceof AnnotationDef) {
            AnnotationDef annotationValue = (AnnotationDef)value;
            builder.addMember(memberName, this.asAnnotationSpec(annotationValue));
        } else if (value instanceof VariableDef) {
            VariableDef variableDef = (VariableDef)value;
            builder.addMember(memberName, this.renderVariable(null, null, variableDef));
        } else if (value instanceof Class) {
            builder.addMember(memberName, "$T.class", value);
        } else if (value instanceof Enum) {
            builder.addMember(memberName, "$T.$L", value.getClass(), ((Enum)value).name());
        } else if (value instanceof String) {
            builder.addMember(memberName, "$S", value);
        } else if (value instanceof Float) {
            builder.addMember(memberName, "$Lf", value);
        } else if (value instanceof Character) {
            builder.addMember(memberName, "'$L'", Util.characterLiteralWithoutSingleQuotes(((Character)value).charValue()));
        } else {
            builder.addMember(memberName, "$L", value);
        }
    }

    private TypeName asType(TypeDef typeDef, ObjectDef objectDef) {
        if (typeDef.equals(TypeDef.THIS)) {
            if (objectDef == null) {
                throw new IllegalStateException("This type is used outside of the instance scope!");
            }
            return this.asType((TypeDef)objectDef.asTypeDef(), null);
        }
        if (typeDef instanceof TypeDef.Array) {
            TypeDef.Array array = (TypeDef.Array)typeDef;
            ArrayTypeName arrayTypeName = ArrayTypeName.of(this.asType(array.componentType(), objectDef));
            for (int i = 1; i < array.dimensions(); ++i) {
                arrayTypeName = ArrayTypeName.of(arrayTypeName);
            }
            return arrayTypeName;
        }
        if (typeDef instanceof ClassTypeDef.Parameterized) {
            ClassTypeDef.Parameterized parameterized = (ClassTypeDef.Parameterized)typeDef;
            return ParameterizedTypeName.get(JavaPoetSourceGenerator.asClassType(parameterized.rawType()), (TypeName[])parameterized.typeArguments().stream().map(t -> this.asType((TypeDef)t, objectDef)).toArray(TypeName[]::new));
        }
        if (typeDef instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)typeDef;
            return switch (primitive.name()) {
                case "void" -> TypeName.VOID;
                case "byte" -> TypeName.BYTE;
                case "short" -> TypeName.SHORT;
                case "char" -> TypeName.CHAR;
                case "int" -> TypeName.INT;
                case "long" -> TypeName.LONG;
                case "float" -> TypeName.FLOAT;
                case "double" -> TypeName.DOUBLE;
                case "boolean" -> TypeName.BOOLEAN;
                default -> throw new IllegalStateException("Unrecognized primitive name: " + primitive.name());
            };
        }
        if (typeDef instanceof ClassTypeDef) {
            ClassTypeDef classType = (ClassTypeDef)typeDef;
            return ClassName.bestGuess(classType.getName());
        }
        if (typeDef instanceof TypeDef.Wildcard) {
            TypeDef.Wildcard wildcard = (TypeDef.Wildcard)typeDef;
            if (!wildcard.lowerBounds().isEmpty()) {
                return WildcardTypeName.supertypeOf(this.asType((TypeDef)wildcard.lowerBounds().get(0), objectDef));
            }
            return WildcardTypeName.subtypeOf(this.asType((TypeDef)wildcard.upperBounds().get(0), objectDef));
        }
        if (typeDef instanceof TypeDef.TypeVariable) {
            TypeDef.TypeVariable typeVariable = (TypeDef.TypeVariable)typeDef;
            return this.asTypeVariable(typeVariable, objectDef);
        }
        throw new IllegalStateException("Unrecognized type definition " + typeDef);
    }

    private static ClassName asClassType(ClassTypeDef classTypeDef) {
        return ClassName.bestGuess(classTypeDef.getName());
    }

    private CodeBlock renderStatement(@Nullable ObjectDef objectDef, MethodDef methodDef, StatementDef statementDef) {
        if (statementDef instanceof StatementDef.Throw) {
            StatementDef.Throw aThrow = (StatementDef.Throw)statementDef;
            return CodeBlock.concat(CodeBlock.of("throw ", new Object[0]), this.renderExpression(objectDef, methodDef, aThrow.variableDef()));
        }
        if (statementDef instanceof StatementDef.Return) {
            StatementDef.Return aReturn = (StatementDef.Return)statementDef;
            return CodeBlock.concat(CodeBlock.of("return ", new Object[0]), this.renderExpression(objectDef, methodDef, aReturn.expression()));
        }
        if (statementDef instanceof StatementDef.Assign) {
            StatementDef.Assign assign = (StatementDef.Assign)statementDef;
            return CodeBlock.concat(this.renderExpression(objectDef, methodDef, (ExpressionDef)assign.variable()), CodeBlock.of(" = ", new Object[0]), this.renderExpression(objectDef, methodDef, assign.expression()));
        }
        if (statementDef instanceof StatementDef.DefineAndAssign) {
            StatementDef.DefineAndAssign assign = (StatementDef.DefineAndAssign)statementDef;
            return CodeBlock.concat(CodeBlock.of("$T $L", this.asType(assign.variable().type(), objectDef), assign.variable().name()), CodeBlock.of(" = ", new Object[0]), this.renderExpression(objectDef, methodDef, assign.expression()));
        }
        if (statementDef instanceof ExpressionDef) {
            ExpressionDef expressionDef = (ExpressionDef)statementDef;
            return this.renderExpression(objectDef, methodDef, expressionDef);
        }
        throw new IllegalStateException("Unrecognized statement: " + statementDef);
    }

    private CodeBlock renderStatementCodeBlock(@Nullable ObjectDef objectDef, MethodDef methodDef, StatementDef statementDef) {
        if (statementDef instanceof StatementDef.Multi) {
            StatementDef.Multi statements = (StatementDef.Multi)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            for (StatementDef statement : statements.statements()) {
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, statement));
            }
            return builder.build();
        }
        if (statementDef instanceof StatementDef.If) {
            StatementDef.If ifStatement = (StatementDef.If)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("if (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, ifStatement.condition()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, ifStatement.statement()));
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.IfElse) {
            StatementDef.IfElse ifStatement = (StatementDef.IfElse)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("if (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, ifStatement.condition()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, ifStatement.statement()));
            builder.unindent();
            builder.add("} else {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, ifStatement.elseStatement()));
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.Switch) {
            StatementDef.Switch aSwitch = (StatementDef.Switch)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("switch (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, aSwitch.expression()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            for (Map.Entry e : aSwitch.cases().entrySet()) {
                if (e.getKey() == null || ((ExpressionDef.Constant)e.getKey()).value() == null) {
                    builder.add("default", new Object[0]);
                } else {
                    builder.add("case ", new Object[0]);
                    builder.add(this.renderConstantExpression((ExpressionDef.Constant)e.getKey()));
                }
                builder.add(": {\n", new Object[0]);
                builder.indent();
                StatementDef statement = (StatementDef)e.getValue();
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, statement));
                builder.unindent();
                builder.add("}\n", new Object[0]);
            }
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        if (statementDef instanceof StatementDef.While) {
            StatementDef.While aWhile = (StatementDef.While)statementDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("while (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, aWhile.expression()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            builder.add(this.renderStatementCodeBlock(objectDef, methodDef, aWhile.statement()));
            builder.unindent();
            builder.add("}\n", new Object[0]);
            return builder.build();
        }
        return CodeBlock.builder().addStatement(this.renderStatement(objectDef, methodDef, statementDef)).build();
    }

    private CodeBlock renderExpression(@Nullable ObjectDef objectDef, MethodDef methodDef, ExpressionDef expressionDef) {
        if (expressionDef instanceof ExpressionDef.NewInstance) {
            ExpressionDef.NewInstance newInstance = (ExpressionDef.NewInstance)expressionDef;
            return CodeBlock.concat(CodeBlock.of("new $L(", this.asType((TypeDef)newInstance.type(), objectDef)), newInstance.values().stream().map(exp -> this.renderExpression(objectDef, methodDef, (ExpressionDef)exp)).collect(CodeBlock.joining(", ")), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.NewArrayOfSize) {
            ExpressionDef.NewArrayOfSize newArray = (ExpressionDef.NewArrayOfSize)expressionDef;
            return CodeBlock.of("new $T[$L]", this.asType(newArray.type().componentType(), objectDef), newArray.size());
        }
        if (expressionDef instanceof ExpressionDef.NewArrayInitialized) {
            ExpressionDef.NewArrayInitialized newArray = (ExpressionDef.NewArrayInitialized)expressionDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T[]{", this.asType(newArray.type().componentType(), objectDef));
            Iterator iterator = newArray.expressions().iterator();
            while (iterator.hasNext()) {
                ExpressionDef expression = (ExpressionDef)iterator.next();
                builder.add(this.renderExpression(objectDef, methodDef, expression));
                if (!iterator.hasNext()) continue;
                builder.add(",", new Object[0]);
            }
            builder.add("}", new Object[0]);
            return builder.build();
        }
        if (expressionDef instanceof ExpressionDef.Convert) {
            ExpressionDef.Convert convertExpressionDef = (ExpressionDef.Convert)expressionDef;
            return this.renderExpression(objectDef, methodDef, convertExpressionDef.expressionDef());
        }
        if (expressionDef instanceof ExpressionDef.Constant) {
            ExpressionDef.Constant constant = (ExpressionDef.Constant)expressionDef;
            return this.renderConstantExpression(constant);
        }
        if (expressionDef instanceof ExpressionDef.CallInstanceMethod) {
            ExpressionDef.CallInstanceMethod callInstanceMethod = (ExpressionDef.CallInstanceMethod)expressionDef;
            return CodeBlock.concat(CodeBlock.of(this.renderExpression(objectDef, methodDef, callInstanceMethod.instance()) + "." + callInstanceMethod.name() + "(", new Object[0]), callInstanceMethod.parameters().stream().map(exp -> this.renderExpression(objectDef, methodDef, (ExpressionDef)exp)).collect(CodeBlock.joining(", ")), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.CallStaticMethod) {
            ExpressionDef.CallStaticMethod staticMethod = (ExpressionDef.CallStaticMethod)expressionDef;
            return CodeBlock.concat(CodeBlock.of("$T." + staticMethod.name() + "(", this.asType((TypeDef)staticMethod.classDef(), objectDef)), staticMethod.parameters().stream().map(exp -> this.renderExpression(objectDef, methodDef, (ExpressionDef)exp)).collect(CodeBlock.joining(", ")), CodeBlock.of(")", new Object[0]));
        }
        if (expressionDef instanceof ExpressionDef.Condition) {
            ExpressionDef.Condition condition = (ExpressionDef.Condition)expressionDef;
            return CodeBlock.concat(this.renderExpression(objectDef, methodDef, condition.left()), CodeBlock.of(condition.operator(), new Object[0]), this.renderExpression(objectDef, methodDef, condition.right()));
        }
        if (expressionDef instanceof ExpressionDef.IfElse) {
            ExpressionDef.IfElse condition = (ExpressionDef.IfElse)expressionDef;
            return CodeBlock.concat(this.renderExpression(objectDef, methodDef, condition.condition()), CodeBlock.of(" ? ", new Object[0]), this.renderExpression(objectDef, methodDef, condition.expression()), CodeBlock.of(" : ", new Object[0]), this.renderExpression(objectDef, methodDef, condition.elseExpression()));
        }
        if (expressionDef instanceof ExpressionDef.Switch) {
            ExpressionDef.Switch aSwitch = (ExpressionDef.Switch)expressionDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("switch (", new Object[0]);
            builder.add(this.renderExpression(objectDef, methodDef, aSwitch.expression()));
            builder.add(") {\n", new Object[0]);
            builder.indent();
            for (Map.Entry e : aSwitch.cases().entrySet()) {
                if (e.getKey() == null || ((ExpressionDef.Constant)e.getKey()).value() == null) {
                    builder.add("default", new Object[0]);
                } else {
                    builder.add("case ", new Object[0]);
                    builder.add(this.renderConstantExpression((ExpressionDef.Constant)e.getKey()));
                }
                builder.add(" -> ", new Object[0]);
                ExpressionDef value = (ExpressionDef)e.getValue();
                builder.add(this.renderExpression(objectDef, methodDef, value));
                if (value instanceof ExpressionDef.SwitchYieldCase) {
                    builder.add("\n", new Object[0]);
                    continue;
                }
                builder.add(";\n", new Object[0]);
            }
            builder.unindent();
            builder.add("}", new Object[0]);
            return builder.build();
        }
        if (expressionDef instanceof ExpressionDef.SwitchYieldCase) {
            ExpressionDef.SwitchYieldCase switchYieldCase = (ExpressionDef.SwitchYieldCase)expressionDef;
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("{\n", new Object[0]);
            builder.indent();
            StatementDef statement = switchYieldCase.statement();
            List flatten = statement.flatten();
            if (flatten.isEmpty()) {
                throw new IllegalStateException("SwitchYieldCase did not return any statements");
            }
            StatementDef last = (StatementDef)flatten.get(flatten.size() - 1);
            List rest = flatten.subList(0, flatten.size() - 1);
            for (StatementDef statementDef : rest) {
                builder.add(this.renderStatementCodeBlock(objectDef, methodDef, statementDef));
            }
            this.renderYield(builder, methodDef, last, objectDef);
            builder.unindent();
            builder.add("}", new Object[0]);
            String str = builder.build().toString();
            return CodeBlock.of(str, new Object[0]);
        }
        if (expressionDef instanceof VariableDef) {
            VariableDef variableDef = (VariableDef)expressionDef;
            return this.renderVariable(objectDef, methodDef, variableDef);
        }
        throw new IllegalStateException("Unrecognized expression: " + expressionDef);
    }

    private void renderYield(CodeBlock.Builder builder, MethodDef methodDef, StatementDef statementDef, ObjectDef objectDef) {
        if (!(statementDef instanceof StatementDef.Return)) {
            throw new IllegalStateException("The last statement of SwitchYieldCase should be a return. Found: " + statementDef);
        }
        StatementDef.Return aReturn = (StatementDef.Return)statementDef;
        builder.addStatement(CodeBlock.concat(CodeBlock.of("yield ", new Object[0]), this.renderExpression(objectDef, methodDef, aReturn.expression())));
    }

    private CodeBlock renderConstantExpression(ExpressionDef.Constant constant) {
        ClassTypeDef classTypeDef;
        TypeDef type = constant.type();
        Object value = constant.value();
        if (value == null) {
            return CodeBlock.of("null", new Object[0]);
        }
        if (type instanceof ClassTypeDef && (classTypeDef = (ClassTypeDef)type).isEnum()) {
            String string;
            if (value instanceof Enum) {
                Enum anEnum = (Enum)value;
                string = anEnum.name();
            } else {
                string = value.toString();
            }
            return this.renderExpression(null, null, (ExpressionDef)new VariableDef.StaticField(type, string, type));
        }
        if (type instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)type;
            return switch (primitive.name()) {
                case "long" -> CodeBlock.of(value + "l", new Object[0]);
                case "float" -> CodeBlock.of(value + "f", new Object[0]);
                case "double" -> CodeBlock.of(value + "d", new Object[0]);
                default -> CodeBlock.of("$L", value);
            };
        }
        if (type instanceof TypeDef.Array) {
            TypeDef.Array arrayDef = (TypeDef.Array)type;
            if (value.getClass().isArray()) {
                String typeName;
                Object array = value;
                CodeBlock values = IntStream.range(0, Array.getLength(array)).mapToObj(i -> this.renderConstantExpression(new ExpressionDef.Constant(arrayDef.componentType(), Array.get(array, i)))).collect(CodeBlock.joining(", "));
                TypeDef typeDef = arrayDef.componentType();
                if (typeDef instanceof ClassTypeDef) {
                    ClassTypeDef arrayClassTypeDef = (ClassTypeDef)typeDef;
                    typeName = arrayClassTypeDef.getSimpleName();
                } else {
                    typeDef = arrayDef.componentType();
                    if (typeDef instanceof TypeDef.Primitive) {
                        TypeDef.Primitive arrayPrimitive = (TypeDef.Primitive)typeDef;
                        typeName = arrayPrimitive.name();
                    } else {
                        throw new IllegalStateException("Unrecognized expression: " + constant);
                    }
                }
                return CodeBlock.concat(CodeBlock.of("new $N[] {", typeName), values, CodeBlock.of("}", new Object[0]));
            }
        } else if (type instanceof ClassTypeDef) {
            ClassTypeDef classTypeDef2 = (ClassTypeDef)type;
            String name = classTypeDef2.getName();
            if (ClassUtils.isJavaLangType((String)name)) {
                return switch (name) {
                    case "java.lang.Long" -> CodeBlock.of(value + "l", new Object[0]);
                    case "java.lang.Float" -> CodeBlock.of(value + "f", new Object[0]);
                    case "java.lang.Double" -> CodeBlock.of(value + "d", new Object[0]);
                    case "java.lang.String" -> CodeBlock.of("$S", value);
                    default -> CodeBlock.of("$L", value);
                };
            }
            return CodeBlock.of("$L", value);
        }
        throw new IllegalStateException("Unrecognized expression: " + constant);
    }

    private CodeBlock renderVariable(@Nullable ObjectDef objectDef, @Nullable MethodDef methodDef, VariableDef variableDef) {
        if (variableDef instanceof VariableDef.Local) {
            VariableDef.Local localVariableDef = (VariableDef.Local)variableDef;
            return CodeBlock.of(localVariableDef.name(), new Object[0]);
        }
        if (variableDef instanceof VariableDef.MethodParameter) {
            VariableDef.MethodParameter parameterVariableDef = (VariableDef.MethodParameter)variableDef;
            if (methodDef == null) {
                throw new IllegalStateException("Accessing method parameters is not available");
            }
            methodDef.getParameter(parameterVariableDef.name());
            return CodeBlock.of(parameterVariableDef.name(), new Object[0]);
        }
        if (variableDef instanceof VariableDef.StaticField) {
            VariableDef.StaticField staticField = (VariableDef.StaticField)variableDef;
            return CodeBlock.of("$T.$L", this.asType(staticField.ownerType(), objectDef), staticField.name());
        }
        if (variableDef instanceof VariableDef.Field) {
            VariableDef.Field field = (VariableDef.Field)variableDef;
            if (objectDef == null) {
                throw new IllegalStateException("Accessing 'this' is not available");
            }
            if (objectDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)objectDef;
                if (!classDef.hasField(field.name())) {
                    throw new IllegalStateException("Field " + field.name() + " is not available in [" + classDef + "]:" + classDef.getFields());
                }
            } else {
                throw new IllegalStateException("Field access no supported on the object definition: " + objectDef);
            }
            return CodeBlock.of(this.renderExpression(objectDef, methodDef, field.instance()) + "." + field.name(), new Object[0]);
        }
        if (variableDef instanceof VariableDef.This) {
            if (objectDef == null) {
                throw new IllegalStateException("Accessing 'this' is not available");
            }
            return CodeBlock.of("this", new Object[0]);
        }
        throw new IllegalStateException("Unrecognized variable: " + variableDef);
    }
}

