/*
 * Decompiled with CFR 0.152.
 */
package io.mokamint.application.service.internal;

import io.hotmoka.closeables.api.OnCloseHandler;
import io.hotmoka.websockets.beans.ExceptionMessages;
import io.hotmoka.websockets.server.AbstractServerEndpoint;
import io.hotmoka.websockets.server.AbstractWebSocketServer;
import io.hotmoka.websockets.server.api.WebSocketServer;
import io.mokamint.application.api.Application;
import io.mokamint.application.api.ApplicationException;
import io.mokamint.application.api.UnknownGroupIdException;
import io.mokamint.application.api.UnknownStateException;
import io.mokamint.application.messages.AbortBlockMessages;
import io.mokamint.application.messages.AbortBlockResultMessages;
import io.mokamint.application.messages.BeginBlockMessages;
import io.mokamint.application.messages.BeginBlockResultMessages;
import io.mokamint.application.messages.CheckPrologExtraMessages;
import io.mokamint.application.messages.CheckPrologExtraResultMessages;
import io.mokamint.application.messages.CheckTransactionMessages;
import io.mokamint.application.messages.CheckTransactionResultMessages;
import io.mokamint.application.messages.CommitBlockMessages;
import io.mokamint.application.messages.CommitBlockResultMessages;
import io.mokamint.application.messages.DeliverTransactionMessages;
import io.mokamint.application.messages.DeliverTransactionResultMessages;
import io.mokamint.application.messages.EndBlockMessages;
import io.mokamint.application.messages.EndBlockResultMessages;
import io.mokamint.application.messages.GetInitialStateIdMessages;
import io.mokamint.application.messages.GetInitialStateIdResultMessages;
import io.mokamint.application.messages.GetPriorityMessages;
import io.mokamint.application.messages.GetPriorityResultMessages;
import io.mokamint.application.messages.GetRepresentationMessages;
import io.mokamint.application.messages.GetRepresentationResultMessages;
import io.mokamint.application.messages.KeepFromMessages;
import io.mokamint.application.messages.KeepFromResultMessages;
import io.mokamint.application.messages.api.AbortBlockMessage;
import io.mokamint.application.messages.api.BeginBlockMessage;
import io.mokamint.application.messages.api.CheckPrologExtraMessage;
import io.mokamint.application.messages.api.CheckTransactionMessage;
import io.mokamint.application.messages.api.CommitBlockMessage;
import io.mokamint.application.messages.api.DeliverTransactionMessage;
import io.mokamint.application.messages.api.EndBlockMessage;
import io.mokamint.application.messages.api.GetInitialStateIdMessage;
import io.mokamint.application.messages.api.GetPriorityMessage;
import io.mokamint.application.messages.api.GetRepresentationMessage;
import io.mokamint.application.messages.api.KeepFromMessage;
import io.mokamint.application.service.api.ApplicationService;
import io.mokamint.node.api.TransactionRejectedException;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationServiceImpl
extends AbstractWebSocketServer
implements ApplicationService {
    private final Application application;
    private final OnCloseHandler this_close = () -> ((ApplicationServiceImpl)this).close();
    private final String logPrefix;
    private static final Logger LOGGER = Logger.getLogger(ApplicationServiceImpl.class.getName());

    public ApplicationServiceImpl(Application application, int port) throws DeploymentException, IOException {
        this.application = application;
        this.logPrefix = "application service(ws://localhost:" + port + "): ";
        this.startContainer("", port, new ServerEndpointConfig[]{CheckPrologExtraEndpoint.config(this), CheckTransactionEndpoint.config(this), GetPriorityEndpoint.config(this), GetRepresentationEndpoint.config(this), GetInitialStateIdEndpoint.config(this), BeginBlockEndpoint.config(this), DeliverTransactionEndpoint.config(this), EndBlockEndpoint.config(this), CommitBlockEndpoint.config(this), AbortBlockEndpoint.config(this), KeepFromEndpoint.config(this)});
        application.addOnCloseHandler(this.this_close);
        LOGGER.info(this.logPrefix + "published");
    }

    protected void closeResources() {
        super.closeResources();
        this.application.removeOnCloseHandler(this.this_close);
        LOGGER.info(this.logPrefix + "closed");
    }

    private void sendExceptionAsync(Session session, Exception e, String id) throws IOException {
        this.sendObjectAsync(session, ExceptionMessages.of((Exception)e, (String)id));
    }

    protected void onCheckPrologExtra(CheckPrologExtraMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /check_prolog_extra request");
        try {
            try {
                this.sendObjectAsync(session, CheckPrologExtraResultMessages.of((boolean)this.application.checkPrologExtra(message.getExtra()), (String)message.getId()));
            }
            catch (ApplicationException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onCheckTransaction(CheckTransactionMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /check_transaction request");
        try {
            try {
                this.application.checkTransaction(message.getTransaction());
                this.sendObjectAsync(session, CheckTransactionResultMessages.of((String)message.getId()));
            }
            catch (ApplicationException | TransactionRejectedException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onGetPriority(GetPriorityMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /get_priority request");
        try {
            try {
                this.sendObjectAsync(session, GetPriorityResultMessages.of((long)this.application.getPriority(message.getTransaction()), (String)message.getId()));
            }
            catch (ApplicationException | TransactionRejectedException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onGetRepresentation(GetRepresentationMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /get_representation request");
        try {
            try {
                this.sendObjectAsync(session, GetRepresentationResultMessages.of((String)this.application.getRepresentation(message.getTransaction()), (String)message.getId()));
            }
            catch (ApplicationException | TransactionRejectedException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onGetInitialStateId(GetInitialStateIdMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /get_initial_state_id request");
        try {
            try {
                this.sendObjectAsync(session, GetInitialStateIdResultMessages.of((byte[])this.application.getInitialStateId(), (String)message.getId()));
            }
            catch (ApplicationException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onBeginBlock(BeginBlockMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /begin_block request");
        try {
            try {
                this.sendObjectAsync(session, BeginBlockResultMessages.of((int)this.application.beginBlock(message.getHeight(), message.getWhen(), message.getStateId()), (String)message.getId()));
            }
            catch (ApplicationException | UnknownStateException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onDeliverTransaction(DeliverTransactionMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /deliver_transaction request");
        try {
            try {
                this.application.deliverTransaction(message.getGroupId(), message.getTransaction());
                this.sendObjectAsync(session, DeliverTransactionResultMessages.of((String)message.getId()));
            }
            catch (ApplicationException | UnknownGroupIdException | TransactionRejectedException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onEndBlock(EndBlockMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /end_block request");
        try {
            try {
                this.sendObjectAsync(session, EndBlockResultMessages.of((byte[])this.application.endBlock(message.getGroupId(), message.getDeadline()), (String)message.getId()));
            }
            catch (ApplicationException | UnknownGroupIdException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onCommitBlock(CommitBlockMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /commit_block request");
        try {
            try {
                this.application.commitBlock(message.getGroupId());
                this.sendObjectAsync(session, CommitBlockResultMessages.of((String)message.getId()));
            }
            catch (ApplicationException | UnknownGroupIdException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onAbortBlock(AbortBlockMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /abort_block request");
        try {
            try {
                this.application.abortBlock(message.getGroupId());
                this.sendObjectAsync(session, AbortBlockResultMessages.of((String)message.getId()));
            }
            catch (ApplicationException | UnknownGroupIdException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    protected void onKeepFrom(KeepFromMessage message, Session session) {
        LOGGER.info(this.logPrefix + "received a /keep_from request");
        try {
            try {
                this.application.keepFrom(message.getStart());
                this.sendObjectAsync(session, KeepFromResultMessages.of((String)message.getId()));
            }
            catch (ApplicationException | InterruptedException | TimeoutException e) {
                this.sendExceptionAsync(session, (Exception)e, message.getId());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, this.logPrefix + "cannot send to session: it might be closed: " + e.getMessage());
        }
    }

    public static class CheckPrologExtraEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onCheckPrologExtra((CheckPrologExtraMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return CheckPrologExtraEndpoint.simpleConfig((WebSocketServer)server, CheckPrologExtraEndpoint.class, (String)"/check_prolog_extra", (Class[])new Class[]{CheckPrologExtraMessages.Decoder.class, CheckPrologExtraResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class CheckTransactionEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onCheckTransaction((CheckTransactionMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return CheckTransactionEndpoint.simpleConfig((WebSocketServer)server, CheckTransactionEndpoint.class, (String)"/check_transaction", (Class[])new Class[]{CheckTransactionMessages.Decoder.class, CheckTransactionResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class GetPriorityEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onGetPriority((GetPriorityMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return GetPriorityEndpoint.simpleConfig((WebSocketServer)server, GetPriorityEndpoint.class, (String)"/get_priority", (Class[])new Class[]{GetPriorityMessages.Decoder.class, GetPriorityResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class GetRepresentationEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onGetRepresentation((GetRepresentationMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return GetRepresentationEndpoint.simpleConfig((WebSocketServer)server, GetRepresentationEndpoint.class, (String)"/get_representation", (Class[])new Class[]{GetRepresentationMessages.Decoder.class, GetRepresentationResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class GetInitialStateIdEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onGetInitialStateId((GetInitialStateIdMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return GetInitialStateIdEndpoint.simpleConfig((WebSocketServer)server, GetInitialStateIdEndpoint.class, (String)"/get_initial_state_id", (Class[])new Class[]{GetInitialStateIdMessages.Decoder.class, GetInitialStateIdResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class BeginBlockEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onBeginBlock((BeginBlockMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return BeginBlockEndpoint.simpleConfig((WebSocketServer)server, BeginBlockEndpoint.class, (String)"/begin_block", (Class[])new Class[]{BeginBlockMessages.Decoder.class, BeginBlockResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class DeliverTransactionEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onDeliverTransaction((DeliverTransactionMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return DeliverTransactionEndpoint.simpleConfig((WebSocketServer)server, DeliverTransactionEndpoint.class, (String)"/deliver_transaction", (Class[])new Class[]{DeliverTransactionMessages.Decoder.class, DeliverTransactionResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class EndBlockEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onEndBlock((EndBlockMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return EndBlockEndpoint.simpleConfig((WebSocketServer)server, EndBlockEndpoint.class, (String)"/end_block", (Class[])new Class[]{EndBlockMessages.Decoder.class, EndBlockResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class CommitBlockEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onCommitBlock((CommitBlockMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return CommitBlockEndpoint.simpleConfig((WebSocketServer)server, CommitBlockEndpoint.class, (String)"/commit_block", (Class[])new Class[]{CommitBlockMessages.Decoder.class, CommitBlockResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class AbortBlockEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onAbortBlock((AbortBlockMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return AbortBlockEndpoint.simpleConfig((WebSocketServer)server, AbortBlockEndpoint.class, (String)"/abort_block", (Class[])new Class[]{AbortBlockMessages.Decoder.class, AbortBlockResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }

    public static class KeepFromEndpoint
    extends AbstractServerEndpoint<ApplicationServiceImpl> {
        public void onOpen(Session session, EndpointConfig config) {
            this.addMessageHandler(session, message -> ((ApplicationServiceImpl)this.getServer()).onKeepFrom((KeepFromMessage)message, session));
        }

        private static ServerEndpointConfig config(ApplicationServiceImpl server) {
            return KeepFromEndpoint.simpleConfig((WebSocketServer)server, KeepFromEndpoint.class, (String)"/keep_from", (Class[])new Class[]{KeepFromMessages.Decoder.class, KeepFromResultMessages.Encoder.class, ExceptionMessages.Encoder.class});
        }
    }
}

