package com.moneyhash.shared.datasource.network.model.card

import com.moneyhash.shared.datasource.network.model.BrandSettingsData
import com.moneyhash.shared.datasource.network.model.payment.Status
import com.moneyhash.shared.domain.model.CardState
import com.moneyhash.shared.domain.model.PaymentActions
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class CardDetails(
    @SerialName("data")
    val data: CardData? = null,
    @SerialName("status")
    val status: Status? = null
)

@Serializable
data class CardData(
    @SerialName("next_action")
    val nextAction: String? = null,
    @SerialName("action_data")
    val actionData: CardActionData? = null,
    @SerialName("card_intent")
    val cardIntent: CardIntent? = null,
    @SerialName("brand_settings")
    val brandSettings: BrandSettingsData? = null,
)

@Serializable
data class CardIntent(
    @SerialName("id")
    val id: String? = null,
    @SerialName("hide_amount_sidebar")
    val hideAmountSidebar: Boolean? = null,
    @SerialName("hide_header")
    val hideHeader: Boolean? = null,
)

@Serializable
data class CardActionData(
    @SerialName("status")
    val status: String? = null
)

fun CardDetails.toCardState(): CardState {
    return when (data?.actionData?.status) {
        PaymentActions.SUCCESSFUL -> {
            CardState.Success(toCardIntentResult())
        }
        PaymentActions.FAILED, PaymentActions.INLINE_FAILED -> {
            CardState.Failed(toCardIntentResult())
        }
        else -> {
            CardState.Unknown
        }
    }
}
