package com.moneyhash.shared.datasource.network.model.common

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * An enum class representing different languages, each associated with an ISO 639-1 code.
 * - [ARABIC] - Represents the Arabic language with the ISO code "ar".
 * - [ENGLISH] - Represents the English language with the ISO code "en".
 * - [FRENCH] - Represents the French language with the ISO code "fr".
 */
@CommonParcelize
@Serializable
enum class Language(
    val isoCode: String
): CommonParcelable {
    @SerialName("ar")
    ARABIC("ar"),

    @SerialName("en")
    ENGLISH("en"),

    @SerialName("fr")
    FRENCH("fr");

    companion object {
        fun fromIsoCode(isoCode: String): Language {
            return entries.firstOrNull { it.isoCode == isoCode } ?: ENGLISH
        }
    }
}