package com.moneyhash.shared.datasource.network.model.discount

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.common.Language
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Represents a discount item with a title in multiple languages, a type, and a value.
 *
 * @property title The localized titles of the discount, keyed by language.
 * @property type The type of discount, either as a flat amount or a percentage.
 * @property value The value of the discount; its interpretation depends on the type.
 */
@Serializable
@CommonParcelize
data class DiscountItem(
    @SerialName("title")
    val title: Map<Language, String>? = null,
    @SerialName("type")
    val type: DiscountType? = null,
    @SerialName("value")
    val value: String? = null
): CommonParcelable