package com.moneyhash.shared.datasource.network.model.discount

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Enumerates the types of discounts that can be applied to a payment.
 *
 * @property type The type of discount as a string, used for serialization.
 */
@Serializable
@CommonParcelize
enum class DiscountType(val type: String): CommonParcelable {
    @SerialName("amount")
    AMOUNT("amount"),

    @SerialName("percentage")
    PERCENTAGE("percentage");
}