package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

/**
 * Data class representing the details of a payment or payout method for intent.
 *
 * This class encapsulates various attributes that define how a payment method operates, including
 * whether confirmation is required, associated icons for the checkout process, the method's name,
 * and whether it is applicable for express checkout.
 *
 * @property confirmationRequired Indicates whether user confirmation is required before proceeding
 *                                 with this payment or payout method. If true, a confirmation popup
 *                                 should be shown to the user.
 * @property checkoutIcons A list of strings representing icons associated with this method,
 *                         which are displayed during the checkout process to visually represent
 *                         the payment option.
 * @property methodName The name of the payment or payout method (e.g., "Credit Card", "Apple Pay").
 * @property method The internal identifier for the payment or payout method.
 * @property useForExpressCheckout Indicates if this method can be used for express checkout options
 *                                 such as digital wallets like Apple Pay, Google Pay, or Samsung Pay.
 *
 */
@Serializable
@CommonParcelize
data class IntentMethodItem(
    @SerialName("confirmation_required")
    val confirmationRequired: Boolean? = false,
    @SerialName("checkout_icons")
    val checkoutIcons: List<String>? = null,
    @JsonNames("payment_method_name", "payout_method_name")
    val methodName: String? = null,
    @JsonNames("payment_method", "payout_method")
    val method: String? = null,
    @SerialName("use_for_express_checkout")
    val useForExpressCheckout: Boolean? = null
): CommonParcelable