package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.datasource.network.model.Redirect
import com.moneyhash.shared.datasource.network.model.common.ProviderExtraData
import com.moneyhash.shared.datasource.network.model.payment.billingfields.InputField
import com.moneyhash.shared.datasource.network.model.payment.billingfields.InputFieldType
import com.moneyhash.shared.util.extensions.toChoicesList
import com.moneyhash.shared.util.extensions.toChoicesMap
import com.moneyhash.shared.util.Constants
import com.moneyhash.shared.util.extensions.mapToChoicesList
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
data class PaymentActionData(
    @SerialName("transaction")
    val transaction: Transaction? = null,
    @SerialName("redirect")
    val redirect: Redirect? = null,
    @SerialName("native_pay_data")
    val nativePaymentData: NativePaymentData? = null,
    @SerialName("form_fields")
    val formFields: FormFields? = null,
    @SerialName("form_title")
    val formTitle: String? = null,
    @SerialName("retry")
    val retry: Boolean? = null,
    @SerialName("iframe_url")
    val iframeUrl: String? = null,
    @SerialName("uuid")
    val uuid: String? = null,
    @SerialName("provider_id")
    val providerId: String? = null,
    @SerialName("provider_extra_data")
    val providerExtraData: ProviderExtraData? = null,
    @SerialName("provider_api_name")
    val providerApiName: String? = null,
    @SerialName("card_token_id")
    val cardTokenID: String? = null,
    @SerialName("card_token_data")
    val cardTokenData: CardTokenData? = null,
    @SerialName("payment_methods")
    val paymentMethods: List<IntentMethodItem>? = null
): CommonParcelable

fun PaymentActionData.getBillingFields(): List<InputField> {
    val fields = mutableListOf<InputField>()

    this.formFields?.billingFields?.forEach { fieldItem ->
        val fieldType = InputFieldType.from(fieldItem.type.orEmpty())

        when (fieldType) {
            InputFieldType.Select -> {
                if(fieldItem.choices.isNullOrEmpty()) {
                    val optionsList = this.providerExtraData?.stateCity?.toChoicesList()
                    val optionsMap = this.providerExtraData?.stateCity?.toChoicesMap()

                    if (fieldItem.fieldName == Constants.STATE_API_NAME_FILED) {
                        fields.add(fieldItem.toInputField(optionsList = optionsList))
                    } else {
                        fields.add(
                            fieldItem.toInputField(
                                optionsMap = optionsMap,
                                dependsOn = Constants.STATE_API_NAME_FILED
                            )
                        )
                    }
                } else {
                    val choices = fieldItem.choices.mapToChoicesList()
                    fields.add(fieldItem.toInputField(optionsList = choices))
                }
            }
            else -> {
                fields.add(fieldItem.toInputField())
            }
        }
    }

    return fields
}

fun PaymentActionData.getShippingFields(): List<InputField> {
    val fields = mutableListOf<InputField>()

    this.formFields?.shippingFields?.forEach { fieldItem ->
        fields.add(fieldItem.toInputField())
    }

    return fields
}