package com.moneyhash.shared.datasource.network.model.payment

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * An enumeration representing different rendering strategies for content display.
 *
 * - `IFRAME`: Renders content within an iframe.
 * - `POPUP_IFRAME`: Renders content in a modal popup that contains an iframe.
 * - `REDIRECT`: Renders content via a full-page redirect.
 * - `NONE`: No rendering strategy is applied.
 */
@CommonParcelize
@Serializable
enum class RenderStrategy(val strategy: String) : CommonParcelable {
    @SerialName("iframe")
    IFRAME("iframe"),

    @SerialName("popup_iframe")
    POPUP_IFRAME("popup_iframe"),

    @SerialName("redirect")
    REDIRECT("redirect"),

    @SerialName("none")
    NONE("none");

    companion object {
        fun from(strategy: String): RenderStrategy {
            return entries.firstOrNull { it.strategy.lowercase() == strategy.lowercase() } ?: NONE
        }
    }
}
