package com.moneyhash.shared.datasource.network.model.payment.billingfields

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@CommonParcelize
@Serializable
data class InputField(
    @SerialName("type")
    val type: InputFieldType,
    @SerialName("name")
    val name: String?,
    @SerialName("value")
    var value: String?,
    @SerialName("label")
    val label: String?,
    @SerialName("max_length")
    val maxLength: Int?,
    @SerialName("is_required")
    val isRequired: Boolean,
    // PLEASE check the serialization name if it's correct
    @SerialName("optionsList")
    val optionsList: List<OptionItem>?,
    @SerialName("options")
    val optionsMap: Map<String, List<OptionItem>>?,
    @SerialName("hint")
    val hint: String?,
    @SerialName("min_length")
    val minLength: Int?,
    @SerialName("read_only")
    val readOnly: Boolean,
    @SerialName("depends_on")
    val dependsOn: String?
): CommonParcelable