package com.moneyhash.shared.datasource.network.model.payment.billingfields

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@CommonParcelize
@Serializable
enum class InputFieldType(val type: String): CommonParcelable {
    @SerialName("text")
    Text("charfield"),
    @SerialName("email")
    Email("emailfield"),
    @SerialName("phone_number")
    PhoneNumber("phonenumberfield"),
    @SerialName("date_field")
    Date("datefield"),
    @SerialName("number_field")
    Number("numberfield"),
    @SerialName("choice_field")
    Select("choicefield");

    companion object {
        fun from(type: String): InputFieldType {
            return entries.firstOrNull { it.type.lowercase() == type.lowercase() } ?: Text
        }
    }
}
