package com.moneyhash.shared.datasource.network.model.payment.methods

import com.moneyhash.shared.datasource.network.model.payment.PaymentInformation
import com.moneyhash.shared.datasource.network.model.payment.PaymentIntentData
import com.moneyhash.shared.util.Constants
import com.moneyhash.shared.datasource.network.model.payment.IntentMethodItem
import com.moneyhash.shared.datasource.network.model.payout.PayoutData
import com.moneyhash.shared.localization.LocalizationManager

internal fun PaymentIntentData.toPaymentMethods(): IntentMethods {
    require(data != null) { LocalizationManager.strings.payment_intent_data_null }
    return data.toPaymentMethods()
}

internal fun PaymentInformation.toPaymentMethods(): IntentMethods {
    val selectedMethod = selectedMethod
    val customerBalances = wallet?.toCustomerBalances(selectedMethod)
    val expressMethods = intent?.paymentMethods.orEmpty()
        .filter { it.useForExpressCheckout == true }.toExpressMethods(selectedMethod)
    val normalMethods = intent?.paymentMethods.orEmpty()
        .filter { it.useForExpressCheckout != true }.toPaymentMethods(selectedMethod)

    val savedCards = savedCards.orEmpty()

    return IntentMethods(
        customerBalances,
        normalMethods,
        expressMethods,
        savedCards
    )
}

fun PayoutData?.toPayoutMethods(): IntentMethods {
    val payoutMethods = this?.intent?.payoutMethods.orEmpty().toPayoutMethods(this?.selectedMethod)

    return IntentMethods(
        payoutMethods = payoutMethods
    )
}

fun List<IntentMethodItem>.toPayoutMethods(selectedMethod: String?) = map {
    it.toPayoutMethod(selectedMethod == it.method)
}

internal fun IntentMethodItem.toPayoutMethod(isSelected: Boolean) = PayoutMethod(
    method,
    methodName,
    isSelected,
    confirmationRequired,
    checkoutIcons
)

internal fun List<IntentMethodItem>.toExpressMethods(selectedMethod: String?) = map {
    it.toExpressMethod(selectedMethod == it.method)
}

internal fun IntentMethodItem.toExpressMethod(isSelected: Boolean) = ExpressMethod(
    method,
    methodName,
    isSelected,
    confirmationRequired,
    checkoutIcons
)

internal fun List<IntentMethodItem>.toPaymentMethods(selectedMethod: String?) = map {
    it.toPaymentMethod(selectedMethod == it.method)
}

internal fun IntentMethodItem.toPaymentMethod(isSelected: Boolean) = PaymentMethod(
    method,
    methodName,
    isSelected,
    confirmationRequired,
    checkoutIcons
)

internal fun Double?.toCustomerBalances(selectedMethod: String?): List<CustomerBalance> {
    return if (this == null || this == 0.0) {
        emptyList()
    } else {
        listOf(
            CustomerBalance(
                balance = this,
                id = Constants.SELFSERVE_WALLET,
                icon = "https://embed.moneyhash.io/assets/selfWalletIcon.767086fb.svg",
                isSelected = selectedMethod == Constants.SELFSERVE_WALLET
            )
        )
    }
}
