package com.moneyhash.shared.datasource.network.model.vault

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.util.Constants
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@CommonParcelize
enum class Brand : CommonParcelable {
    @SerialName("visa")
    VISA,

    @SerialName("mastercard")
    MASTERCARD,

    @SerialName("mada")
    MADA,

    @SerialName("unknown")
    UNKNOWN

}

@Serializable
@CommonParcelize
data class CardBrand(
    @SerialName("brand")
    val brand: Brand,
    @SerialName("first6Digits")
    val first6Digits: String = "",
    @SerialName("brandIconUrl")
    val brandIconUrl: String
) : CommonParcelable
