package com.moneyhash.shared.datasource.network.services

import com.moneyhash.shared.datasource.network.base.BaseService
import com.moneyhash.shared.datasource.network.model.payment.UseSelfWalletRequest
import com.moneyhash.shared.datasource.network.model.vault.CardDetails
import com.moneyhash.shared.datasource.network.model.vault.VaultData
import com.moneyhash.shared.datasource.services.VaultService
import com.moneyhash.shared.util.Environment
import com.moneyhash.shared.util.Type
import io.ktor.client.HttpClient
import io.ktor.client.call.body
import io.ktor.client.request.header
import io.ktor.client.request.post
import io.ktor.client.request.setBody
import io.ktor.client.request.url
import io.ktor.http.ContentType
import io.ktor.http.contentType

class VaultServiceImpl(
    private val vaultService: BaseService
): VaultService {
    @Throws(Throwable::class)
    override suspend fun postTokens(accessToken: String, cardDetails: CardDetails): VaultData =
        vaultService.post<VaultData>() {
            endpoint(Type.VAULT.resultSuffix)
            header("Mh-Authorization", accessToken)
            body(cardDetails)
        }

}