package com.moneyhash.shared.di

import co.touchlab.kermit.Severity
import com.moneyhash.shared.interacators.payment.PaymentUseCase
import com.moneyhash.shared.securevault.collectors.CardCollector
import com.moneyhash.shared.securevault.collectors.CardFieldsCollector
import com.moneyhash.shared.util.DefaultLogManager
import com.moneyhash.shared.util.LoggerSeverity

class PaymentInformationModule(private val networkModule: NetworkModule) {
    init {
        DefaultLogManager.setSeverity(LoggerSeverity.None)
    }

    val payment: PaymentUseCase by lazy {
        PaymentUseCase(
            paymentService = networkModule.paymentService,
        )
    }

    val cardCollector: CardCollector by lazy {
        CardCollector(networkModule.vaultService)
    }

    val cardFieldsCollector: CardFieldsCollector by lazy {
        CardFieldsCollector(networkModule.vaultService)
    }
}
