package com.moneyhash.shared.domain.model

import com.moneyhash.shared.datasource.network.model.card.CardIntentResult
import com.moneyhash.shared.datasource.network.model.payment.PaymentInformation
import com.moneyhash.shared.datasource.network.model.payout.PayoutData

sealed class CardState {
    class Success(val cardResult: CardIntentResult) : CardState()

    class Failed(val cardResult: CardIntentResult) : CardState()

    object Unknown : CardState()

    class Error(val errors: List<String>) : CardState()
}