package com.moneyhash.shared.errorhandling

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.CommonRawValue
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonArray

@Serializable
@CommonParcelize
internal data class NetworkErrorModel(
    @SerialName("code")
    val code: Int,
    @SerialName("message")
    val message: String?,
    @SerialName("errors")
    val errors: @CommonRawValue JsonArray,
) : CommonParcelable

@Serializable
@CommonParcelize
internal data class NetworkApiErrorResponseModel(
    @SerialName("status")
    val error: NetworkErrorModel?= null,
    @SerialName("detail")
    val detail: String?= null,
) : CommonParcelable
