package com.moneyhash.shared.interacators.auth

import com.moneyhash.shared.datasource.network.model.auth.AuthResponse
import com.moneyhash.shared.datasource.services.AuthService
import com.moneyhash.shared.errorhandling.ErrorMapper
import com.moneyhash.shared.errorhandling.MHThrowable
import com.moneyhash.shared.errorhandling.executeCatching

class AuthUseCase(
    private val authService: AuthService,
) {
    @Throws(Throwable::class)
    suspend fun login(email: String, password: String): AuthResponse = executeCatching(block= {
        return authService.login(email, password)
    })
}