package com.moneyhash.shared.interacators.sandbox

import com.moneyhash.shared.datasource.network.model.sandbox.DemoIntentResponse
import com.moneyhash.shared.datasource.services.SandboxService
import com.moneyhash.shared.errorhandling.MHThrowable
import com.moneyhash.shared.errorhandling.ErrorMapper
import com.moneyhash.shared.errorhandling.executeCatching

class SandboxUseCase(
    private val sandboxService: SandboxService,
) {
    @Throws(Throwable::class)
    suspend fun getDemoIntents(accessToken: String): DemoIntentResponse = executeCatching(block= {
        sandboxService.getDemoIntents(accessToken = accessToken)
    })
}






