package com.moneyhash.shared.localization

object LocalizationManager {
    private var currentLocale: Locale = Locale.En // Default locale
    private lateinit var currentStrings: Strings

    init {
        updateLocale(currentLocale)
    }

    fun updateLocale(locale: Locale) {
        currentLocale = locale
        currentStrings = Locale.localizedStrings(locale)
    }

    val strings: Strings
        get() = currentStrings

    val locale: Locale
        get() = currentLocale
}