package com.moneyhash.shared.localization

internal class EnStrings : Strings {
    override val card_access_token_missing_client: String by lazy { "Card access token is missing." }
    override val tokenize_card_info_mandatory_client: String by lazy { "tokenizeCardInfo is mandatory. Please use the method set(tokenizeCardInfo:TokenizeCardInfo)." }
    override val apple_pay_not_compatible_client: String by lazy { "This device is not compatible with ApplePay." }
    override val apple_pay_authorization_unavailable_client: String by lazy { "Unable to present ApplePay authorization." }
    override val apple_pay_authorization_closed_client: String by lazy { "User closed ApplePay authorization." }
    override val apple_pay_transaction_failed_client: String by lazy { "ApplePay transaction failed." }
    override val swapping_time_environment_client: String by lazy { "Swapping time and environment" }
    override val moneyhash_cancelled_client: String by lazy { "MoneyHash cancelled" }
    override val error_processing_card_client: String by lazy { "Sorry, we encountered an error while processing your card. Please try again later or you may want to check your dashboard for more details on the status of your card." }
    override val error_processing_payout_client: String by lazy { "Sorry, we encountered an error while processing your payout. Please try again later or you may want to check your dashboard for more details on the status of your payout." }
    override val error_processing_payment_client: String by lazy { "Sorry, we encountered an error while processing your payment. Please try again later or you may want to check your dashboard for more details on the status of your payment." }
    override fun input_length_error(textLength: String, validLengths: String): String {
        return "The length of the input text ($textLength) does not match the allowed lengths: $validLengths."
    }
    override val input_empty: String by lazy { "The input text is empty." }
    override val input_non_digit: String by lazy { "The input text contains non-digit characters." }
    override val input_luhn_fail: String by lazy { "The input text does not pass the Luhn check." }
    override val input_non_numeric: String by lazy { "The input text contains non-numeric characters." }
    override val input_non_alphabet: String by lazy { "The input text contains non-alphabet characters." }
    override fun input_range_error(intValue: String, range: String): String {
        return "The value of the input ($intValue) is outside the allowed range: $range."
    }
    override fun validator_not_exist(type: String): String {
        return "Validator does not exist for type: $type"
    }
    override val card_number: String by lazy { "Card Number" }
    override val expiry_month: String by lazy { "Expiry Month" }
    override val expiry_year: String by lazy { "Expiry Year" }
    override val cvv: String by lazy { "CVV" }
    override val card_holder_name: String by lazy { "Card Holder Name" }
    override fun unknown_type(type: String): String {
        return "Unknown type: $type"
    }
    override val invalid_intent_type: String by lazy { "Invalid intent type, Card intent is not supported yet." }
    override fun unsupported_payment_intent_method(methodType: String): String {
        return "Method type $methodType is not supported in payment intents."
    }
    override fun unsupported_payout_intent_method(methodType: String): String {
        return "Method type $methodType is not supported in payout intents."
    }
    override val no_internet_connection: String by lazy { "No internet connection available." }
    override val something_wrong: String by lazy { "Oops, something went wrong. Please try again later." }
    override val payment_intent_data_null: String by lazy { "PaymentIntentData data is null" }
    override val expiration_date_past: String by lazy { "Expiration date is in the past." }
    override fun missing_fields(fields: String): String {
        return "$fields is required"
    }
    override fun redundant_fields(fields: String): String {
        return "Redundant: $fields"
    }
    override fun invalid_field(field: String): String {
        return "$field is invalid"
    }
}

internal class ArStrings : Strings {
    override val card_access_token_missing_client: String by lazy { "رمز وصول البطاقة مفقود." }
    override val tokenize_card_info_mandatory_client: String by lazy { "معلومات بطاقة التوكين ضرورية. يرجى استخدام الطريقة set(tokenizeCardInfo:TokenizeCardInfo)." }
    override val apple_pay_not_compatible_client: String by lazy { "هذا الجهاز غير متوافق مع ApplePay." }
    override val apple_pay_authorization_unavailable_client: String by lazy { "لا يمكن تقديم تفويض ApplePay." }
    override val apple_pay_authorization_closed_client: String by lazy { "المستخدم أغلق تفويض ApplePay." }
    override val apple_pay_transaction_failed_client: String by lazy { "فشلت عملية ApplePay." }
    override val swapping_time_environment_client: String by lazy { "تغيير الوقت والبيئة" }
    override val moneyhash_cancelled_client: String by lazy { "تم إلغاء MoneyHash" }
    override val error_processing_card_client: String by lazy { "عذراً، حدث خطأ أثناء معالجة بطاقتك. يرجى المحاولة لاحقاً أو يمكنك التحقق من لوحة التحكم لمزيد من التفاصيل حول حالة بطاقتك." }
    override val error_processing_payout_client: String by lazy { "عذراً، حدث خطأ أثناء معالجة دفعتك. يرجى المحاولة لاحقاً أو يمكنك التحقق من لوحة التحكم لمزيد من التفاصيل حول حالة دفعتك." }
    override val error_processing_payment_client: String by lazy { "عذراً، حدث خطأ أثناء معالجة الدفعة. يرجى المحاولة لاحقاً أو يمكنك التحقق من لوحة التحكم لمزيد من التفاصيل حول حالة الدفعة." }
    override fun input_length_error(textLength: String, validLengths: String): String {
        return "طول النص المدخل ($textLength) لا يتطابق مع الأطوال المسموح بها: $validLengths."
    }
    override val input_empty: String by lazy { "النص المدخل فارغ." }
    override val input_non_digit: String by lazy { "النص المدخل يحتوي على أحرف غير رقمية." }
    override val input_luhn_fail: String by lazy { "النص المدخل لا يجتاز اختبار لون." }
    override val input_non_numeric: String by lazy { "النص المدخل يحتوي على أحرف غير عددية." }
    override val input_non_alphabet: String by lazy { "النص المدخل يحتوي على أحرف غير أبجدية." }
    override fun input_range_error(intValue: String, range: String): String {
        return "قيمة الإدخال ($intValue) خارج النطاق المسموح: $range."
    }
    override fun validator_not_exist(type: String): String {
        return "لا يوجد مدقق للنوع: $type"
    }
    override val card_number: String by lazy { "رقم البطاقة" }
    override val expiry_month: String by lazy { "شهر الانتهاء" }
    override val expiry_year: String by lazy { "سنة الانتهاء" }
    override val cvv: String by lazy { "رمز CVV" }
    override val card_holder_name: String by lazy { "اسم حامل البطاقة" }
    override fun unknown_type(type: String): String {
        return "نوع مجهول: $type"
    }
    override val invalid_intent_type: String by lazy { "نوع النية غير صالح، نية البطاقة غير مدعومة بعد." }
    override fun unsupported_payment_intent_method(methodType: String): String {
        return "نوع الطريقة $methodType غير مدعوم في نوايا الدفع."
    }
    override fun unsupported_payout_intent_method(methodType: String): String {
        return "نوع الطريقة $methodType غير مدعوم في نوايا الدفع النقدي."
    }
    override val no_internet_connection: String by lazy { "لا يوجد اتصال بالإنترنت." }
    override val something_wrong: String by lazy { "عذرًا، حدث خطأ ما. يرجى المحاولة لاحقًا." }
    override val payment_intent_data_null: String by lazy { "بيانات PaymentIntentData فارغة" }
    override val expiration_date_past: String by lazy { "تاريخ الانتهاء في الماضي." }
    override fun missing_fields(fields: String): String {
        return "$fields مطلوب"
    }
    override fun redundant_fields(fields: String): String {
        return "مكرر: $fields"
    }
    override fun invalid_field(field: String): String {
        return "$field غير صالح"
    }
}

internal class FrStrings : Strings {
    override val card_access_token_missing_client: String by lazy { "Le jeton d'accès à la carte est manquant." }
    override val tokenize_card_info_mandatory_client: String by lazy { "L'information de la carte Tokenize est obligatoire. Veuillez utiliser la méthode set(tokenizeCardInfo:TokenizeCardInfo)." }
    override val apple_pay_not_compatible_client: String by lazy { "Cet appareil n'est pas compatible avec ApplePay." }
    override val apple_pay_authorization_unavailable_client: String by lazy { "Impossible de présenter l'autorisation ApplePay." }
    override val apple_pay_authorization_closed_client: String by lazy { "L'utilisateur a fermé l'autorisation ApplePay." }
    override val apple_pay_transaction_failed_client: String by lazy { "La transaction ApplePay a échoué." }
    override val swapping_time_environment_client: String by lazy { "Échange de temps et d'environnement" }
    override val moneyhash_cancelled_client: String by lazy { "MoneyHash annulé" }
    override val error_processing_card_client: String by lazy { "Désolé, nous avons rencontré une erreur lors du traitement de votre carte. Veuillez réessayer plus tard ou vous pouvez vérifier votre tableau de bord pour plus de détails sur l'état de votre carte." }
    override val error_processing_payout_client: String by lazy { "Désolé, nous avons rencontré une erreur lors du traitement de votre paiement. Veuillez réessayer plus tard ou vous pouvez vérifier votre tableau de bord pour plus de détails sur l'état de votre paiement." }
    override val error_processing_payment_client: String by lazy { "Désolé, nous avons rencontré une erreur lors du traitement de votre paiement. Veuillez réessayer plus tard ou vous pouvez vérifier votre tableau de bord pour plus de détails sur l'état de votre paiement." }
    override fun input_length_error(textLength: String, validLengths: String): String {
        return "La longueur du texte saisi ($textLength) ne correspond pas aux longueurs autorisées : $validLengths."
    }
    override val input_empty: String by lazy { "Le texte saisi est vide." }
    override val input_non_digit: String by lazy { "Le texte saisi contient des caractères non numériques." }
    override val input_luhn_fail: String by lazy { "Le texte saisi ne passe pas le contrôle Luhn." }
    override val input_non_numeric: String by lazy { "Le texte saisi contient des caractères non numériques." }
    override val input_non_alphabet: String by lazy { "Le texte saisi contient des caractères non alphabétiques." }
    override fun input_range_error(intValue: String, range: String): String {
        return "La valeur de l'entrée ($intValue) est en dehors de la plage autorisée : $range."
    }
    override fun validator_not_exist(type: String): String {
        return "Il n'existe pas de validateur pour le type : $type"
    }
    override val card_number: String by lazy { "Numéro de carte" }
    override val expiry_month: String by lazy { "Mois d'expiration" }
    override val expiry_year: String by lazy { "Année d'expiration" }
    override val cvv: String by lazy { "CVV" }
    override val card_holder_name: String by lazy { "Nom du titulaire de la carte" }
    override fun unknown_type(type: String): String {
        return "Type inconnu : $type"
    }
    override val invalid_intent_type: String by lazy { "Type d'intention invalide, l'intention de carte n'est pas encore prise en charge." }
    override fun unsupported_payment_intent_method(methodType: String): String {
        return "Le type de méthode $methodType n'est pas pris en charge dans les intentions de paiement."
    }
    override fun unsupported_payout_intent_method(methodType: String): String {
        return "Le type de méthode $methodType n'est pas pris en charge dans les intentions de paiement."
    }
    override val no_internet_connection: String by lazy { "Pas de connexion Internet disponible." }
    override val something_wrong: String by lazy { "Oups, quelque chose s'est mal passé. Veuillez réessayer plus tard." }
    override val payment_intent_data_null: String by lazy { "Les données de PaymentIntentData sont nulles" }
    override val expiration_date_past: String by lazy { "La date d'expiration est passée." }
    override fun missing_fields(fields: String): String {
        return "$fields est requis"
    }
    override fun redundant_fields(fields: String): String {
        return "Redondant : $fields"
    }
    override fun invalid_field(field: String): String {
        return "$field est invalide"
    }
}

