package com.moneyhash.shared.securevault.exceptions

import com.moneyhash.shared.errorhandling.ErrorType
import com.moneyhash.shared.errorhandling.MHThrowable

sealed class CardFormExceptions(message: String) : MHThrowable(message, type =  ErrorType.CARD_VALIDATION) {
    class InvalidFieldException(message: String) : CardFormExceptions(message)
    class MissingFieldTypeException(message: String) : CardFormExceptions(message)
    class RedundantFieldTypeException(message: String) : CardFormExceptions(message)
    class ExpireDateIsInThePast(message: String) : CardFormExceptions(message)
}