package com.moneyhash.shared.securevault.fields

import com.moneyhash.shared.CommonParcelable
import com.moneyhash.shared.CommonParcelize
import com.moneyhash.shared.localization.LocalizationManager
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * An enumeration representing the different types of card fields.
 *
 * - `CARD_NUMBER`: Represents the card number field.
 * - `CVV`: Represents the CVV field.
 * - `CARD_HOLDER_NAME`: Represents the cardholder name field.
 * - `EXPIRE_MONTH`: Represents the expiration month field.
 * - `EXPIRE_YEAR`: Represents the expiration year field.
 */
@Serializable
@CommonParcelize
enum class FieldType(val type: String, val label: String) : CommonParcelable {
    @SerialName("card_number")
    CARD_NUMBER("card_number", LocalizationManager.strings.card_number),

    @SerialName("expire_month")
    EXPIRE_MONTH("expire_month", LocalizationManager.strings.expiry_month),

    @SerialName("expire_year")
    EXPIRE_YEAR("expire_year", LocalizationManager.strings.expiry_year),

    @SerialName("cvv")
    CVV("cvv", LocalizationManager.strings.cvv),

    @SerialName("card_holder_name")
    CARD_HOLDER_NAME("card_holder_name", LocalizationManager.strings.card_holder_name);

    companion object {
        internal fun from(type: String): FieldType {
            return entries.firstOrNull { it.type.equals(type, true) }
                ?: throw IllegalArgumentException(LocalizationManager.strings.unknown_type(type))
        }
    }
}
