package com.moneyhash.shared.securevault.formatters

internal class ExpireYearFormatter : TextFormatter {
    private val formatter: TextFormatter

    init {
        val limitFormat = LimitFormat(2)
        val numericFormat = NumericFormat()

        numericFormat.setNextFormatter(limitFormat)
        formatter = numericFormat
    }

    override fun format(text: String): String {
        return formatter.format(text)
    }

    override fun removeFormat(text: String): String {
        return formatter.removeFormat(text)
    }
}