package com.moneyhash.shared.securevault.validators

import com.moneyhash.shared.securevault.models.CardBrandInternal

internal class CVVValidator(private val cardBrandInternal: CardBrandInternal) : Validator {
    private val validator: Validator

    init {
        val lengthValidator = LengthValidator(cardBrandInternal.defaultCVCLengths())
        val numericValidator = NumericValidator()

        numericValidator.setNextValidator(lengthValidator)
        validator = numericValidator
    }

    @Throws(Throwable::class)
    override fun validate(text: String): Boolean {
        return validator.validate(text)
    }
}