package com.moneyhash.shared.securevault.validators

internal class CardHolderNameValidator : Validator {
    private val validator: Validator

    init {
        val lengthValidator = LengthValidator(listOf(0) + (6..20).toList())
        val onlyAlphabet = OnlyAlphabetValidator()

        lengthValidator.setNextValidator(onlyAlphabet)
        validator = lengthValidator
    }

    @Throws(Throwable::class)
    override fun validate(text: String): Boolean {
        return validator.validate(text)
    }
}
