package com.moneyhash.shared.securevault.validators

import com.moneyhash.shared.localization.LocalizationManager
import com.moneyhash.shared.securevault.exceptions.ValidationException
import com.moneyhash.shared.util.DefaultLogManager


internal class OnlyAlphabetValidator : BaseValidator() {
    override fun validate(text: String): Boolean {
        DefaultLogManager.info("Validating alphabetic value for text: '$text'")

        val alphabetRegex = "^([a-zA-Z]+[a-zA-Z ]*)?$".toRegex()

        if (text.trim().isEmpty()) {
            val message = LocalizationManager.strings.input_empty
            DefaultLogManager.error(message)
        }

        if (!alphabetRegex.matches(text)) {
            val message = "The input text contains non-alphabet characters."
            DefaultLogManager.error(message)
            throw ValidationException.AlphabetValidationException(LocalizationManager.strings.input_non_alphabet)
        }

        DefaultLogManager.info("Validation successful: The input text contains only alphabetic characters.")
        return super.validate(text)
    }
}