package com.moneyhash.shared.securevault.validators

import com.moneyhash.shared.localization.LocalizationManager
import com.moneyhash.shared.securevault.exceptions.ValidationException
import com.moneyhash.shared.util.DefaultLogManager

internal class RangeValueValidator<R : ClosedRange<Int>>(private val range: R) : BaseValidator() {
    override fun validate(text: String): Boolean {
        DefaultLogManager.info("Validating range value for text: '$text'")

        if (text.trim().isEmpty()) {
            val message = LocalizationManager.strings.input_empty
            DefaultLogManager.error(message)
            throw ValidationException.EmptyValueException(message)
        }

        val intValue = text.toIntOrNull()
        if (intValue == null || !range.contains(intValue)) {
            val message = "The value of the input ($intValue) is outside the allowed range: $range."
            DefaultLogManager.error(message)
            throw ValidationException.RangeValueValidationException(LocalizationManager.strings.input_range_error("$intValue", "$range"))
        }

        DefaultLogManager.info("Validation successful: The value of the input ($intValue) is within the allowed range: $range.")
        return super.validate(text)
    }
}
