package com.moneyhash.shared.util

enum class Environment(
    val baseUrl: String,
    val embedUrl: String,
    val vaultUrl: String,
    val debuggable: Boolean = false
) {

    // Use this for local development and testing if you have the backend running locally and needed
//    Local(
//        "http://localhost:8000/api/v1.1/",
//        "http://localhost:8080/embed/",
//        "http://localhost:8001/api/v1",
//        true
//    ),

    Staging(
        "https://staging-web.moneyhash.io/api/v1.1/",
        "https://stg-embed.moneyhash.io/embed/",
        "https://vault-staging.moneyhash.io/api/v1/",
        true
    ),
    Production(
        "https://web.moneyhash.io/api/v1.1/",
        "https://embed.moneyhash.io/embed/",
        "https://vault.moneyhash.io/api/v1/",
        false
    ),
}

enum class Type(val type: String, val resultSuffix: String) {
    PAYMENT("payment", "client/payments/intents/"),
    PAYOUT("payout", "client/payout/intents/"),
    CARDS("card", "client/tokens/intents/"),
    VAULT("vault", "tokens/");


    companion object {
        fun from(type: String): Type {
            return entries.firstOrNull { it.type == type } ?: PAYMENT
        }
    }
}