package com.moneyhash.shared.util.extensions

import com.moneyhash.shared.datasource.network.model.payment.billingfields.OptionItem
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.JsonPrimitive
import kotlinx.serialization.json.buildJsonObject


val JsonWithIgnoredUnknownKeys = kotlinx.serialization.json.Json {
    ignoreUnknownKeys = true
    encodeDefaults = true
    isLenient = true
    allowSpecialFloatingPointValues = true
    allowStructuredMapKeys = true
    useAlternativeNames = true
    prettyPrint = false
    useArrayPolymorphism = false
}

fun List<JsonElement>.toStringContent(): List<String> {
    val content = mutableListOf<String>()
    this.forEach { element ->
        if (element is JsonPrimitive && element.isString) {
            content.add(element.content)
        } else if (element is Map<*, *>) {
            element.values.forEach { value ->
                if (value is String) {
                    content.add(value)
                } else if (value is JsonArray) {
                    value.forEach { valueInList ->
                        if (valueInList is JsonPrimitive && valueInList.isString) {
                            content.add(valueInList.content)
                        }
                    }
                }
            }
        }
    }

    return content
}

fun Map<String, List<String>>.toChoicesList(): List<OptionItem> {
    val choicesList = mutableListOf<OptionItem>()
    this.keys.forEach { key ->
        choicesList.add(OptionItem(key, key))
    }
    return choicesList
}
fun Map<String, List<String>>.toChoicesMap(): Map<String, List<OptionItem>> {
    val choicesMap = mutableMapOf<String, List<OptionItem>>()
    this.keys.forEach { key ->
        val valueList = this[key]?.map { value -> OptionItem(value, value) } ?: emptyList()
        choicesMap[key] = valueList
    }
    return choicesMap
}
fun Map<String, String>.toJsonObject(): JsonObject {
    return buildJsonObject {
        this@toJsonObject.forEach { (key, value) ->
            put(key, JsonPrimitive(value))
        }
    }
}

fun Map<String, String>.mapToChoicesList(): List<OptionItem> {
    val choicesList = mutableListOf<OptionItem>()
    this.forEach { item ->
        choicesList.add(OptionItem(item.key, item.value))
    }
    return choicesList
}